/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.View;

public class DefaultHighlighter
extends LayeredHighlighter {
    public static final LayeredHighlighter.LayerPainter DefaultPainter = new DefaultHighlightPainter(null);
    private JTextComponent textComponent;
    private Vector highlights;

    private /* synthetic */ void finit$() {
        this.highlights = new Vector();
    }

    public DefaultHighlighter() {
        this.finit$();
    }

    private void checkPositions(int p0, int p1) throws BadLocationException {
        if (p0 < 0) {
            throw new BadLocationException("DefaultHighlighter", p0);
        }
        if (p1 < p0) {
            throw new BadLocationException("DefaultHighlighter", p1);
        }
    }

    public void install(JTextComponent c) {
        this.textComponent = c;
        this.removeAllHighlights();
    }

    public void deinstall(JTextComponent c) {
        this.textComponent = null;
    }

    public Object addHighlight(int p0, int p1, Highlighter.HighlightPainter painter) throws BadLocationException {
        this.checkPositions(p0, p1);
        HighlightEntry entry = new HighlightEntry(this, p0, p1, painter);
        this.highlights.add(entry);
        return entry;
    }

    public void removeHighlight(Object tag) {
        this.highlights.remove(tag);
    }

    public void removeAllHighlights() {
        this.highlights.clear();
    }

    public Highlighter.Highlight[] getHighlights() {
        return null;
    }

    public void changeHighlight(Object tag, int p0, int p1) throws BadLocationException {
        this.checkPositions(p0, p1);
        HighlightEntry entry = (HighlightEntry)tag;
        entry.p0 = p0;
        entry.p1 = p1;
    }

    public void paintLayeredHighlights(Graphics g, int p0, int p1, Shape viewBounds, JTextComponent editor, View view) {
    }

    public void paint(Graphics g) {
        if (this.highlights.size() == 0) {
            return;
        }
        Rectangle bounds = this.textComponent.getBounds();
        for (int index = 0; index < this.highlights.size(); ++index) {
            HighlightEntry entry = (HighlightEntry)this.highlights.get(index);
            entry.painter.paint(g, entry.p0, entry.p1, bounds, this.textComponent);
        }
    }

    private class HighlightEntry {
        private /* synthetic */ DefaultHighlighter this$0;
        int p0;
        int p1;
        Highlighter.HighlightPainter painter;

        public HighlightEntry(DefaultHighlighter this$0, int p0, int p1, Highlighter.HighlightPainter painter) {
            this.this$0 = this$0;
            this.p0 = p0;
            this.p1 = p1;
            this.painter = painter;
        }

        public int getStartPosition() {
            return this.p0;
        }

        public int getEndPosition() {
            return this.p1;
        }

        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }
    }

    public static class DefaultHighlightPainter
    extends LayeredHighlighter.LayerPainter {
        private Color color;

        public DefaultHighlightPainter(Color c) {
            this.color = c;
        }

        public Color getColor() {
            return this.color;
        }

        private void paintHighlight(Graphics g, Rectangle rect) {
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }

        public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
            Rectangle r0 = null;
            Rectangle r1 = null;
            Rectangle rect = bounds.getBounds();
            try {
                r0 = c.modelToView(p0);
                r1 = c.modelToView(p1);
            }
            catch (BadLocationException e) {
                return;
            }
            if (r0 == null || r1 == null) {
                return;
            }
            if (this.color == null) {
                g.setColor(c.getSelectionColor());
            } else {
                g.setColor(this.color);
            }
            if (r0.y == r1.y) {
                r0.width = r1.x - r0.x;
                this.paintHighlight(g, r0);
                return;
            }
            r0.width = rect.x + rect.width - r0.x;
            this.paintHighlight(g, r0);
            r0.y += r0.height;
            r0.x = rect.x;
            while (r0.y < r1.y) {
                this.paintHighlight(g, r0);
                r0.y += r0.height;
            }
            this.paintHighlight(g, r1);
        }

        public Shape paintLayer(Graphics g, int p0, int p1, Shape bounds, JTextComponent c, View view) {
            throw new InternalError();
        }
    }
}

