/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Position;

public class FieldView
extends PlainView {
    public FieldView(Element elem) {
        super(elem);
    }

    protected FontMetrics getFontMetrics() {
        Container container = this.getContainer();
        return container.getFontMetrics(container.getFont());
    }

    public float getPreferredSpan(int axis) {
        String text;
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException();
        }
        FontMetrics fm = this.getFontMetrics();
        if (axis == 1) {
            return fm.getHeight();
        }
        Element elem = this.getElement();
        try {
            text = elem.getDocument().getText(elem.getStartOffset(), elem.getEndOffset());
        }
        catch (BadLocationException e) {
            text = "";
            System.out.println("Michael: FieldView.getPreferredSpan: Error");
        }
        return fm.stringWidth(text);
    }

    public int getResizeWeight(int axis) {
        axis = axis == 0 ? 1 : 0;
        return axis;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias bias) throws BadLocationException {
        return super.modelToView(pos, a, bias);
    }

    public void paint(Graphics g, Shape s) {
        super.paint(g, s);
    }
}

