/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputMethodListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.Keymap;

public abstract class JTextComponent
extends JComponent
implements Scrollable,
Accessible {
    private static final long serialVersionUID = -8796518220218978795L;
    public static final String DEFAULT_KEYMAP = "default";
    public static final String FOCUS_ACCELERATOR_KEY = "focusAcceleratorKey";
    private static Hashtable keymaps;
    private Keymap keymap;
    private Document doc;
    private Caret caret;
    private Highlighter highlighter;
    private Color caretColor;
    private Color disabledTextColor;
    private Color selectedTextColor;
    private Color selectionColor;
    private boolean editable;
    private Insets margin;

    public static Keymap getKeymap(String n) {
        return (Keymap)keymaps.get(n);
    }

    public static Keymap removeKeymap(String n) {
        Keymap km = (Keymap)keymaps.get(n);
        keymaps.remove(n);
        return km;
    }

    public static Keymap addKeymap(String n, Keymap parent) {
        DefaultKeymap k = new DefaultKeymap(n);
        k.setResolveParent(parent);
        if (n != null) {
            keymaps.put(n, k);
        }
        return k;
    }

    Keymap getKeymap() {
        return this.keymap;
    }

    public void setKeymap(Keymap k) {
        KeymapWrapper kw = k == null ? null : new KeymapWrapper(this, k);
        InputMap childInputMap = this.getInputMap(0);
        if (childInputMap == null) {
            this.setInputMap(0, kw);
        } else {
            while (childInputMap.getParent() != null && !(childInputMap.getParent() instanceof KeymapWrapper) && !(childInputMap.getParent() instanceof InputMapUIResource)) {
                childInputMap = childInputMap.getParent();
            }
            if (childInputMap.getParent() == null) {
                childInputMap.setParent(kw);
            } else if (childInputMap.getParent() instanceof KeymapWrapper) {
                if (kw == null) {
                    childInputMap.setParent(childInputMap.getParent().getParent());
                } else {
                    kw.setParent(childInputMap.getParent().getParent());
                    childInputMap.setParent(kw);
                }
            } else if (childInputMap.getParent() instanceof InputMapUIResource && kw != null) {
                kw.setParent(childInputMap.getParent());
                childInputMap.setParent(kw);
            }
        }
        KeymapActionMap kam = k == null ? null : new KeymapActionMap(this, k);
        ActionMap childActionMap = this.getActionMap();
        if (childActionMap == null) {
            this.setActionMap(kam);
        } else {
            while (childActionMap.getParent() != null && !(childActionMap.getParent() instanceof KeymapActionMap) && !(childActionMap.getParent() instanceof ActionMapUIResource)) {
                childActionMap = childActionMap.getParent();
            }
            if (childActionMap.getParent() == null) {
                childActionMap.setParent(kam);
            } else if (childActionMap.getParent() instanceof KeymapActionMap) {
                if (kam == null) {
                    childActionMap.setParent(childActionMap.getParent().getParent());
                } else {
                    kam.setParent(childActionMap.getParent().getParent());
                    childActionMap.setParent(kam);
                }
            } else if (childActionMap.getParent() instanceof ActionMapUIResource && kam != null) {
                kam.setParent(childActionMap.getParent());
                childActionMap.setParent(kam);
            }
        }
        Keymap old = this.keymap;
        this.keymap = k;
        this.firePropertyChange("keymap", old, k);
    }

    public static void loadKeymap(Keymap map, KeyBinding[] bindings, Action[] actions) {
        int i;
        Hashtable acts = new Hashtable(actions.length);
        for (i = 0; i < actions.length; ++i) {
            acts.put(actions[i].getValue("Name"), actions[i]);
        }
        for (i = 0; i < bindings.length; ++i) {
            if (!acts.containsKey(bindings[i].actionName)) continue;
            map.addActionForKeyStroke(bindings[i].key, (Action)acts.get(bindings[i].actionName));
        }
    }

    public Action[] getActions() {
        return this.getUI().getEditorKit(this).getActions();
    }

    public JTextComponent() {
        Keymap defkeymap = JTextComponent.getKeymap(DEFAULT_KEYMAP);
        boolean creatingKeymap = false;
        if (defkeymap == null) {
            defkeymap = JTextComponent.addKeymap(DEFAULT_KEYMAP, null);
            defkeymap.setDefaultAction(new DefaultEditorKit.DefaultKeyTypedAction());
            creatingKeymap = true;
        }
        this.setFocusable(true);
        this.enableEvents(8);
        this.updateUI();
        if (creatingKeymap) {
            JTextComponent.loadKeymap(defkeymap, new KeyBinding[]{new KeyBinding(KeyStroke.getKeyStroke(37, 0), "caret-backward"), new KeyBinding(KeyStroke.getKeyStroke(39, 0), "caret-forward"), new KeyBinding(KeyStroke.getKeyStroke("typed \b"), "delete-previous"), new KeyBinding(KeyStroke.getKeyStroke("typed \u007f"), "delete-next")}, this.getActions());
        }
    }

    public void setDocument(Document newDoc) {
        Document oldDoc = this.doc;
        this.doc = newDoc;
        this.firePropertyChange("document", oldDoc, newDoc);
        this.revalidate();
        this.repaint();
    }

    public Document getDocument() {
        return this.doc;
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    public void setMargin(Insets m) {
        this.margin = m;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setText(String text) {
        try {
            this.doc.remove(0, this.doc.getLength());
            this.doc.insertString(0, text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public String getText() {
        if (this.doc == null) {
            return null;
        }
        try {
            return this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    public String getText(int offset, int length) throws BadLocationException {
        return this.getDocument().getText(offset, length);
    }

    public String getUIClassID() {
        return "TextComponentUI";
    }

    protected String paramString() {
        return "JTextComponent";
    }

    public TextUI getUI() {
        return (TextUI)this.ui;
    }

    public void setUI(TextUI newUI) {
        super.setUI(newUI);
    }

    public void updateUI() {
        this.setUI((TextUI)UIManager.getUI(this));
    }

    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    public int getScrollableUnitIncrement(Rectangle visible, int orientation, int direction) {
        return 0;
    }

    public int getScrollableBlockIncrement(Rectangle visible, int orientation, int direction) {
        return 0;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.firePropertyChange("editable", this.editable, editable);
        this.editable = editable;
    }

    public Caret getCaret() {
        return this.caret;
    }

    public void setCaret(Caret newCaret) {
        if (this.caret != null) {
            this.caret.deinstall(this);
        }
        Caret oldCaret = this.caret;
        this.caret = newCaret;
        if (this.caret != null) {
            this.caret.install(this);
        }
        this.firePropertyChange("caret", oldCaret, newCaret);
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color newColor) {
        Color oldCaretColor = this.caretColor;
        this.caretColor = newColor;
        this.firePropertyChange("caretColor", oldCaretColor, newColor);
    }

    public Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(Color newColor) {
        Color oldColor = this.disabledTextColor;
        this.disabledTextColor = newColor;
        this.firePropertyChange("disabledTextColor", oldColor, newColor);
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(Color newColor) {
        Color oldColor = this.selectedTextColor;
        this.selectedTextColor = newColor;
        this.firePropertyChange("selectedTextColor", oldColor, newColor);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color newColor) {
        Color oldColor = this.selectionColor;
        this.selectionColor = newColor;
        this.firePropertyChange("selectionColor", oldColor, newColor);
    }

    public int getCaretPosition() {
        return this.caret.getDot();
    }

    public void setCaretPosition(int position) {
        if (this.doc == null) {
            return;
        }
        if (position < 0 || position > this.doc.getLength()) {
            throw new IllegalArgumentException();
        }
        this.caret.setDot(position);
    }

    public void moveCaretPosition(int position) {
        if (this.doc == null) {
            return;
        }
        if (position < 0 || position > this.doc.getLength()) {
            throw new IllegalArgumentException();
        }
        this.caret.moveDot(position);
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(Highlighter newHighlighter) {
        if (this.highlighter != null) {
            this.highlighter.deinstall(this);
        }
        Highlighter oldHighlighter = this.highlighter;
        this.highlighter = newHighlighter;
        if (this.highlighter != null) {
            this.highlighter.install(this);
        }
        this.firePropertyChange("highlighter", oldHighlighter, newHighlighter);
    }

    public int getSelectionStart() {
        return Math.min(this.caret.getDot(), this.caret.getMark());
    }

    public void setSelectionStart(int start) {
        this.select(start, this.getSelectionEnd());
    }

    public int getSelectionEnd() {
        return Math.max(this.caret.getDot(), this.caret.getMark());
    }

    public void setSelectionEnd(int end) {
        this.select(this.getSelectionStart(), end);
    }

    public void select(int start, int end) {
        int length = this.doc.getLength();
        start = Math.max(start, 0);
        start = Math.min(start, length);
        end = Math.max(end, 0);
        end = Math.min(end, length);
        this.setCaretPosition(start);
        this.moveCaretPosition(end);
    }

    public void selectAll() {
        this.select(0, this.doc.getLength());
    }

    public synchronized void replaceSelection(String content) {
        int dot = this.caret.getDot();
        int mark = this.caret.getMark();
        if (content == null) {
            this.caret.setDot(dot);
            return;
        }
        try {
            if (dot != mark) {
                this.doc.remove(Math.min(dot, mark), Math.max(dot, mark));
            }
            this.doc.insertString(Math.min(dot, mark), content, null);
        }
        catch (BadLocationException e) {
            System.out.println("Michael: JTextComponent.replaceSelection: Error");
        }
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public void addCaretListener(CaretListener listener) {
        this.listenerList.add(JTextComponent.class$("javax.swing.event.CaretListener"), listener);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void removeCaretListener(CaretListener listener) {
        this.listenerList.remove(JTextComponent.class$("javax.swing.event.CaretListener"), listener);
    }

    public CaretListener[] getCaretListeners() {
        return (CaretListener[])this.getListeners(JTextComponent.class$("javax.swing.event.CaretListener"));
    }

    protected void fireCaretUpdate(CaretEvent event) {
        CaretListener[] listeners = this.getCaretListeners();
        for (int index = 0; index < listeners.length; ++index) {
            listeners[index].caretUpdate(event);
        }
    }

    public void addInputMethodListener(InputMethodListener listener) {
        this.listenerList.add(JTextComponent.class$("java.awt.event.InputMethodListener"), listener);
    }

    public void removeInputMethodListener(InputMethodListener listener) {
        this.listenerList.remove(JTextComponent.class$("java.awt.event.InputMethodListener"), listener);
    }

    public InputMethodListener[] getInputMethodListeners() {
        return (InputMethodListener[])this.getListeners(JTextComponent.class$("java.awt.event.InputMethodListener"));
    }

    public Rectangle modelToView(int position) throws BadLocationException {
        return this.getUI().modelToView(this, position);
    }

    static {
        DEFAULT_KEYMAP = DEFAULT_KEYMAP;
        FOCUS_ACCELERATOR_KEY = FOCUS_ACCELERATOR_KEY;
        keymaps = new Hashtable();
    }

    static class DefaultKeymap
    implements Keymap {
        String name;
        Keymap parent;
        Hashtable map;
        Action defaultAction;

        public DefaultKeymap(String name) {
            this.name = name;
            this.map = new Hashtable();
        }

        public void addActionForKeyStroke(KeyStroke key, Action a) {
            this.map.put(key, a);
        }

        public Action getAction(KeyStroke key) {
            if (this.map.containsKey(key)) {
                return (Action)this.map.get(key);
            }
            if (this.parent != null) {
                return this.parent.getAction(key);
            }
            return null;
        }

        public Action[] getBoundActions() {
            Action[] ret = new Action[this.map.size()];
            Enumeration e = this.map.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                ret[i++] = (Action)e.nextElement();
            }
            return ret;
        }

        public KeyStroke[] getBoundKeyStrokes() {
            KeyStroke[] ret = new KeyStroke[this.map.size()];
            Enumeration e = this.map.keys();
            int i = 0;
            while (e.hasMoreElements()) {
                ret[i++] = (KeyStroke)e.nextElement();
            }
            return ret;
        }

        public Action getDefaultAction() {
            return this.defaultAction;
        }

        public KeyStroke[] getKeyStrokesForAction(Action a) {
            int i = 0;
            Enumeration e = this.map.keys();
            while (e.hasMoreElements()) {
                if (!this.map.get(e.nextElement()).equals(a)) continue;
                ++i;
            }
            KeyStroke[] ret = new KeyStroke[i];
            i = 0;
            e = this.map.keys();
            while (e.hasMoreElements()) {
                KeyStroke k = (KeyStroke)e.nextElement();
                if (!this.map.get(k).equals(a)) continue;
                ret[i++] = k;
            }
            return ret;
        }

        public String getName() {
            return this.name;
        }

        public Keymap getResolveParent() {
            return this.parent;
        }

        public boolean isLocallyDefined(KeyStroke key) {
            return this.map.containsKey(key);
        }

        public void removeBindings() {
            this.map.clear();
        }

        public void removeKeyStrokeBinding(KeyStroke key) {
            this.map.remove(key);
        }

        public void setDefaultAction(Action a) {
            this.defaultAction = a;
        }

        public void setResolveParent(Keymap p) {
            this.parent = p;
        }
    }

    private class KeymapActionMap
    extends ActionMap {
        private /* synthetic */ JTextComponent this$0;
        Keymap map;

        public KeymapActionMap(JTextComponent this$0, Keymap k) {
            this.this$0 = this$0;
            this.map = k;
        }

        public Action get(Object cmd) {
            if (cmd instanceof Action) {
                return (Action)cmd;
            }
            return super.get(cmd);
        }

        public int size() {
            return this.map.getBoundKeyStrokes().length + super.size();
        }

        public Object[] keys() {
            int i;
            Object[] superKeys = super.keys();
            KeyStroke[] mapKeys = this.map.getBoundKeyStrokes();
            Object[] bothKeys = new Object[superKeys.length + mapKeys.length];
            for (i = 0; i < superKeys.length; ++i) {
                bothKeys[i] = superKeys[i];
            }
            for (i = 0; i < mapKeys.length; ++i) {
                bothKeys[i + superKeys.length] = mapKeys[i];
            }
            return bothKeys;
        }

        public Object[] allKeys() {
            int i;
            Object[] superKeys = super.allKeys();
            KeyStroke[] mapKeys = this.map.getBoundKeyStrokes();
            Object[] bothKeys = new Object[superKeys.length + mapKeys.length];
            for (i = 0; i < superKeys.length; ++i) {
                bothKeys[i] = superKeys[i];
            }
            for (i = 0; i < mapKeys.length; ++i) {
                bothKeys[i + superKeys.length] = mapKeys[i];
            }
            return bothKeys;
        }
    }

    private class KeymapWrapper
    extends InputMap {
        private /* synthetic */ JTextComponent this$0;
        Keymap map;

        public KeymapWrapper(JTextComponent this$0, Keymap k) {
            this.this$0 = this$0;
            this.map = k;
        }

        public int size() {
            return this.map.getBoundKeyStrokes().length + super.size();
        }

        public Object get(KeyStroke ks) {
            Action mapped = null;
            Keymap m = this.map;
            while (mapped == null && m != null) {
                mapped = m.getAction(ks);
                if (mapped == null && ks.getKeyEventType() == 400) {
                    mapped = m.getDefaultAction();
                }
                if (mapped != null) continue;
                m = m.getResolveParent();
            }
            if (mapped == null) {
                return super.get(ks);
            }
            return mapped;
        }

        public KeyStroke[] keys() {
            int i;
            KeyStroke[] superKeys = super.keys();
            KeyStroke[] mapKeys = this.map.getBoundKeyStrokes();
            KeyStroke[] bothKeys = new KeyStroke[superKeys.length + mapKeys.length];
            for (i = 0; i < superKeys.length; ++i) {
                bothKeys[i] = superKeys[i];
            }
            for (i = 0; i < mapKeys.length; ++i) {
                bothKeys[i + superKeys.length] = mapKeys[i];
            }
            return bothKeys;
        }

        public KeyStroke[] allKeys() {
            int i;
            KeyStroke[] superKeys = super.allKeys();
            KeyStroke[] mapKeys = this.map.getBoundKeyStrokes();
            KeyStroke[] bothKeys = new KeyStroke[superKeys.length + mapKeys.length];
            for (i = 0; i < superKeys.length; ++i) {
                bothKeys[i] = superKeys[i];
            }
            for (i = 0; i < mapKeys.length; ++i) {
                bothKeys[i + superKeys.length] = mapKeys[i];
            }
            return bothKeys;
        }
    }

    public static class KeyBinding {
        public KeyStroke key;
        public String actionName;

        public KeyBinding(KeyStroke key, String actionName) {
            this.key = key;
            this.actionName = actionName;
        }
    }

    public class AccessibleJTextComponent
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    CaretListener,
    DocumentListener {
        private /* synthetic */ JTextComponent this$0;
        private static final long serialVersionUID = 7664188944091413696L;

        public AccessibleJTextComponent(JTextComponent this$0) {
            this.this$0 = this$0;
            super(this$0);
        }

        public int getCaretPosition() {
            return 0;
        }

        public String getSelectedText() {
            return null;
        }

        public int getSelectionStart() {
            return 0;
        }

        public int getSelectionEnd() {
            return 0;
        }

        public void caretUpdate(CaretEvent value0) {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return null;
        }

        public AccessibleText getAccessibleText() {
            return null;
        }

        public void insertUpdate(DocumentEvent value0) {
        }

        public void removeUpdate(DocumentEvent value0) {
        }

        public void changedUpdate(DocumentEvent value0) {
        }

        public int getIndexAtPoint(Point value0) {
            return 0;
        }

        Rectangle getRootEditorRect() {
            return null;
        }

        public Rectangle getCharacterBounds(int value0) {
            return null;
        }

        public int getCharCount() {
            return 0;
        }

        public AttributeSet getCharacterAttribute(int value0) {
            return null;
        }

        public String getAtIndex(int value0, int value1) {
            return null;
        }

        public String getAfterIndex(int value0, int value1) {
            return null;
        }

        public String getBeforeIndex(int value0, int value1) {
            return null;
        }
    }
}

