/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;

public class PlainView
extends View
implements TabExpander {
    private Color selectedColor;
    private Color unselectedColor;
    private Font font;
    protected FontMetrics metrics;

    public PlainView(Element elem) {
        super(elem);
    }

    protected void updateMetrics() {
        Container component = this.getContainer();
        Font font = component.getFont();
        if (this.font != font) {
            this.font = font;
            this.metrics = component.getFontMetrics(font);
        }
    }

    protected Rectangle lineToRect(Shape a, int line) {
        this.updateMetrics();
        Rectangle rect = a.getBounds();
        int fontHeight = this.metrics.getHeight();
        return new Rectangle(rect.x, rect.y + line * fontHeight, rect.width, fontHeight);
    }

    public Shape modelToView(int position, Shape a, Position.Bias b) throws BadLocationException {
        Document document = this.getDocument();
        int lineIndex = this.getElement().getElementIndex(position);
        Rectangle rect = this.lineToRect(a, lineIndex);
        Element line = this.getElement().getElement(lineIndex);
        int lineStart = line.getStartOffset();
        Segment segment = new Segment();
        document.getText(lineStart, position - lineStart, segment);
        int xoffset = Utilities.getTabbedTextWidth(segment, this.metrics, rect.x, this, lineStart);
        rect.x += xoffset;
        rect.width = 1;
        rect.height = this.metrics.getHeight();
        return rect;
    }

    public void drawLine(int lineIndex, Graphics g, int x, int y) {
        try {
            this.metrics = g.getFontMetrics();
            this.drawUnselectedText(g, x, y, 0, this.getDocument().getLength());
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    public int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        g.setColor(this.selectedColor);
        Segment segment = new Segment();
        this.getDocument().getText(p0, p1 - p0, segment);
        return Utilities.drawTabbedText(segment, x, y, g, this, 0);
    }

    public int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        g.setColor(this.unselectedColor);
        Segment segment = new Segment();
        this.getDocument().getText(p0, p1 - p0, segment);
        return Utilities.drawTabbedText(segment, x, y, g, this, 0);
    }

    public void paint(Graphics g, Shape s) {
        JTextComponent textComponent = (JTextComponent)this.getContainer();
        g.setFont(textComponent.getFont());
        this.selectedColor = textComponent.getSelectedTextColor();
        this.unselectedColor = textComponent.getForeground();
        Rectangle rect = s.getBounds();
        this.drawLine(0, g, rect.x, rect.y);
    }

    public int getTabSize() {
        return 8;
    }

    public float nextTabStop(float x, int tabStop) {
        float tabSizePixels = this.getTabSize() + this.metrics.charWidth('m');
        return (float)(Math.floor(x / tabSizePixels) + 1.0) * tabSizePixels;
    }

    public float getPreferredSpan(int axis) {
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException();
        }
        return 10.0f;
    }
}

