/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;

public class SimpleAttributeSet
implements MutableAttributeSet,
Serializable,
Cloneable {
    Hashtable tab = new Hashtable();
    static AttributeSet EMPTY = new SimpleAttributeSet();

    public SimpleAttributeSet() {
        this(null);
    }

    public SimpleAttributeSet(AttributeSet a) {
        this.addAttributes(a);
    }

    public void addAttribute(Object name, Object value) {
        this.tab.put(name, value);
    }

    public void addAttributes(AttributeSet attributes) {
        Enumeration e = attributes.getAttributeNames();
        while (e.hasMoreElements()) {
            Object name = e.nextElement();
            Object val = attributes.getAttribute(name);
            this.tab.put(name, val);
        }
    }

    public Object clone() {
        SimpleAttributeSet s = new SimpleAttributeSet();
        s.tab = (Hashtable)this.tab.clone();
        return s;
    }

    public boolean containsAttribute(Object name, Object value) {
        return this.tab.containsKey(name) && this.tab.get(name).equals(value);
    }

    public boolean containsAttributes(AttributeSet attributes) {
        Enumeration e = attributes.getAttributeNames();
        while (e.hasMoreElements()) {
            Object val;
            Object name = e.nextElement();
            if (this.containsAttribute(name, val = attributes.getAttribute(name))) continue;
            return false;
        }
        return true;
    }

    public AttributeSet copyAttributes() {
        return (AttributeSet)this.clone();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof SimpleAttributeSet && ((SimpleAttributeSet)obj).tab.equals(this.tab);
    }

    public Object getAttribute(Object name) {
        Object val = this.tab.get(name);
        if (val != null) {
            return val;
        }
        AttributeSet p = this.getResolveParent();
        if (p != null && p instanceof AttributeSet) {
            return p.getAttribute(name);
        }
        return null;
    }

    public int getAttributeCount() {
        return this.tab.size();
    }

    public Enumeration getAttributeNames() {
        return this.tab.keys();
    }

    public AttributeSet getResolveParent() {
        return (AttributeSet)this.tab.get(AttributeSet.ResolveAttribute);
    }

    public int hashCode() {
        return this.tab.hashCode();
    }

    public boolean isDefined(Object attrName) {
        return this.tab.containsKey(attrName);
    }

    public boolean isEmpty() {
        return this.tab.isEmpty();
    }

    public boolean isEqual(AttributeSet attr) {
        return this.equals(attr);
    }

    public void removeAttribute(Object name) {
        this.tab.remove(name);
    }

    public void removeAttributes(AttributeSet attributes) {
        this.removeAttributes(attributes.getAttributeNames());
    }

    public void removeAttributes(Enumeration names) {
        while (names.hasMoreElements()) {
            this.removeAttribute(names.nextElement());
        }
    }

    public void setResolveParent(AttributeSet parent) {
        this.addAttribute(AttributeSet.ResolveAttribute, parent);
    }

    public String toString() {
        return this.tab.toString();
    }
}

