/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class StyleContext
implements Serializable,
AbstractDocument.AttributeContext {
    public static final String DEFAULT_STYLE = "default";
    static Hashtable sharedAttributeSets;
    static Hashtable sharedFonts;
    static StyleContext defaultStyleContext;
    static final int compressionThreshold = 9;
    EventListenerList listenerList = new EventListenerList();
    Hashtable styleTable = new Hashtable();

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    protected SmallAttributeSet createSmallAttributeSet(AttributeSet a) {
        return new SmallAttributeSet(this, a);
    }

    protected MutableAttributeSet createLargeAttributeSet(AttributeSet a) {
        return new SimpleAttributeSet(a);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(StyleContext.class$("javax.swing.event.ChangeListener"), listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(StyleContext.class$("javax.swing.event.ChangeListener"), listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(StyleContext.class$("javax.swing.event.ChangeListener"));
    }

    public Style addStyle(String name, Style parent) {
        NamedStyle newStyle = new NamedStyle(this, name, parent);
        if (name != null) {
            this.styleTable.put(name, newStyle);
        }
        return newStyle;
    }

    public void removeStyle(String name) {
        this.styleTable.remove(name);
    }

    public Style getStyle(String name) {
        return (Style)this.styleTable.get(name);
    }

    public Enumeration getStyleNames() {
        return this.styleTable.keys();
    }

    public Font getFont(AttributeSet attr) {
        String family = StyleConstants.getFontFamily(attr);
        int style = 0;
        if (StyleConstants.isBold(attr)) {
            ++style;
        }
        if (StyleConstants.isItalic(attr)) {
            style += 2;
        }
        int size = StyleConstants.getFontSize(attr);
        return this.getFont(family, style, size);
    }

    public Font getFont(String family, int style, int size) {
        SimpleFontSpec spec = new SimpleFontSpec(family, style, size);
        if (sharedFonts.containsKey(spec)) {
            return (Font)sharedFonts.get(spec);
        }
        Font tmp = new Font(family, style, size);
        sharedFonts.put(spec, tmp);
        return tmp;
    }

    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    public Color getForeground(AttributeSet a) {
        return StyleConstants.getForeground(a);
    }

    public Color getBackground(AttributeSet a) {
        return StyleConstants.getBackground(a);
    }

    protected int getCompressionThreshold() {
        return 9;
    }

    public static StyleContext getDefaultStyleContext() {
        return defaultStyleContext;
    }

    public AttributeSet addAttribute(AttributeSet old, Object name, Object value) {
        if (old instanceof MutableAttributeSet) {
            ((MutableAttributeSet)old).addAttribute(name, value);
            return old;
        }
        MutableAttributeSet mutable = this.createLargeAttributeSet(old);
        mutable.addAttribute(name, value);
        if (mutable.getAttributeCount() >= this.getCompressionThreshold()) {
            return mutable;
        }
        SmallAttributeSet small = this.createSmallAttributeSet(mutable);
        if (sharedAttributeSets.containsKey(small)) {
            small = (SmallAttributeSet)sharedAttributeSets.get(small);
        } else {
            sharedAttributeSets.put(small, small);
        }
        return small;
    }

    public AttributeSet addAttributes(AttributeSet old, AttributeSet attributes) {
        if (old instanceof MutableAttributeSet) {
            ((MutableAttributeSet)old).addAttributes(attributes);
            return old;
        }
        MutableAttributeSet mutable = this.createLargeAttributeSet(old);
        mutable.addAttributes(attributes);
        if (mutable.getAttributeCount() >= this.getCompressionThreshold()) {
            return mutable;
        }
        SmallAttributeSet small = this.createSmallAttributeSet(mutable);
        if (sharedAttributeSets.containsKey(small)) {
            small = (SmallAttributeSet)sharedAttributeSets.get(small);
        } else {
            sharedAttributeSets.put(small, small);
        }
        return small;
    }

    public AttributeSet getEmptySet() {
        AttributeSet e = this.createSmallAttributeSet(null);
        if (sharedAttributeSets.containsKey(e)) {
            e = (AttributeSet)sharedAttributeSets.get(e);
        } else {
            sharedAttributeSets.put(e, e);
        }
        return e;
    }

    public void reclaim(AttributeSet attributes) {
        if (sharedAttributeSets.containsKey(attributes)) {
            sharedAttributeSets.remove(attributes);
        }
    }

    public AttributeSet removeAttribute(AttributeSet old, Object name) {
        if (old instanceof MutableAttributeSet) {
            ((MutableAttributeSet)old).removeAttribute(name);
            if (old.getAttributeCount() < this.getCompressionThreshold()) {
                SmallAttributeSet small = this.createSmallAttributeSet(old);
                if (!sharedAttributeSets.containsKey(small)) {
                    sharedAttributeSets.put(small, small);
                }
                old = (AttributeSet)sharedAttributeSets.get(small);
            }
            return old;
        }
        MutableAttributeSet mutable = this.createLargeAttributeSet(old);
        mutable.removeAttribute(name);
        SmallAttributeSet small = this.createSmallAttributeSet(mutable);
        if (sharedAttributeSets.containsKey(small)) {
            small = (SmallAttributeSet)sharedAttributeSets.get(small);
        } else {
            sharedAttributeSets.put(small, small);
        }
        return small;
    }

    public AttributeSet removeAttributes(AttributeSet old, AttributeSet attributes) {
        return this.removeAttributes(old, attributes.getAttributeNames());
    }

    public AttributeSet removeAttributes(AttributeSet old, Enumeration names) {
        if (old instanceof MutableAttributeSet) {
            ((MutableAttributeSet)old).removeAttributes(names);
            if (old.getAttributeCount() < this.getCompressionThreshold()) {
                SmallAttributeSet small = this.createSmallAttributeSet(old);
                if (!sharedAttributeSets.containsKey(small)) {
                    sharedAttributeSets.put(small, small);
                }
                old = (AttributeSet)sharedAttributeSets.get(small);
            }
            return old;
        }
        MutableAttributeSet mutable = this.createLargeAttributeSet(old);
        mutable.removeAttributes(names);
        SmallAttributeSet small = this.createSmallAttributeSet(mutable);
        if (sharedAttributeSets.containsKey(small)) {
            small = (SmallAttributeSet)sharedAttributeSets.get(small);
        } else {
            sharedAttributeSets.put(small, small);
        }
        return small;
    }

    public static Object getStaticAttribute(Object key) {
        throw new InternalError("not implemented");
    }

    public static Object getStaticAttributeKey(Object key) {
        throw new InternalError("not implemented");
    }

    public static void readAttributeSet(ObjectInputStream in, MutableAttributeSet a) throws ClassNotFoundException, IOException {
        throw new InternalError("not implemented");
    }

    public static void writeAttributeSet(ObjectOutputStream out, AttributeSet a) throws IOException {
        throw new InternalError("not implemented");
    }

    public void readAttributes(ObjectInputStream in, MutableAttributeSet a) throws ClassNotFoundException, IOException {
        throw new InternalError("not implemented");
    }

    public void writeAttributes(ObjectOutputStream out, AttributeSet a) throws IOException {
        throw new InternalError("not implemented");
    }

    static {
        DEFAULT_STYLE = DEFAULT_STYLE;
        sharedAttributeSets = new Hashtable();
        sharedFonts = new Hashtable();
        defaultStyleContext = new StyleContext();
    }

    private static class SimpleFontSpec {
        String family;
        int style;
        int size;

        public SimpleFontSpec(String family, int style, int size) {
            this.family = family;
            this.style = style;
            this.size = size;
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof SimpleFontSpec && ((SimpleFontSpec)obj).family.equals(this.family) && ((SimpleFontSpec)obj).style == this.style && ((SimpleFontSpec)obj).size == this.size;
        }

        public int hashCode() {
            return this.family.hashCode() + this.style + this.size;
        }
    }

    public class SmallAttributeSet
    implements AttributeSet {
        private /* synthetic */ StyleContext this$0;
        final Object[] attrs;

        public SmallAttributeSet(StyleContext this$0, AttributeSet a) {
            this.this$0 = this$0;
            if (a == null) {
                this.attrs = new Object[0];
            } else {
                int n = a.getAttributeCount();
                int i = 0;
                this.attrs = new Object[n * 2];
                Enumeration e = a.getAttributeNames();
                while (e.hasMoreElements()) {
                    Object name = e.nextElement();
                    this.attrs[i++] = name;
                    this.attrs[i++] = a.getAttribute(name);
                }
            }
        }

        public SmallAttributeSet(StyleContext this$0, Object[] a) {
            this.this$0 = this$0;
            if (a == null) {
                this.attrs = new Object[0];
            } else {
                this.attrs = new Object[a.length];
                System.arraycopy(a, 0, this.attrs, 0, a.length);
            }
        }

        public Object clone() {
            return new SmallAttributeSet(this.this$0, this.attrs);
        }

        public boolean containsAttribute(Object name, Object value) {
            for (int i = 0; i < this.attrs.length; i += 2) {
                if (!this.attrs[i].equals(name) || !this.attrs[i + 1].equals(value)) continue;
                return true;
            }
            return false;
        }

        public boolean containsAttributes(AttributeSet a) {
            Enumeration e = a.getAttributeNames();
            while (e.hasMoreElements()) {
                Object val;
                Object name = e.nextElement();
                if (this.containsAttribute(name, val = a.getAttribute(name))) continue;
                return false;
            }
            return true;
        }

        public AttributeSet copyAttributes() {
            return (AttributeSet)this.clone();
        }

        public boolean equals(Object obj) {
            return obj instanceof SmallAttributeSet && this.isEqual((AttributeSet)obj);
        }

        public Object getAttribute(Object key) {
            for (int i = 0; i < this.attrs.length; i += 2) {
                if (!this.attrs[i].equals(key)) continue;
                return this.attrs[i + 1];
            }
            AttributeSet p = this.getResolveParent();
            if (p != null && p instanceof AttributeSet) {
                return p.getAttribute(key);
            }
            return null;
        }

        public int getAttributeCount() {
            return this.attrs.length / 2;
        }

        public Enumeration getAttributeNames() {
            return new Enumeration(this){
                private /* synthetic */ SmallAttributeSet this$1;
                int i;
                {
                    this.this$1 = this$1;
                    this.finit$();
                }

                private /* synthetic */ void finit$() {
                    this.i = 0;
                }

                public boolean hasMoreElements() {
                    return this.i < this.this$1.attrs.length;
                }

                public Object nextElement() {
                    this.i += 2;
                    return this.this$1.attrs[this.i - 2];
                }
            };
        }

        public AttributeSet getResolveParent() {
            return (AttributeSet)this.getAttribute(AttributeSet.ResolveAttribute);
        }

        public int hashCode() {
            return Arrays.asList(this.attrs).hashCode();
        }

        public boolean isDefined(Object key) {
            for (int i = 0; i < this.attrs.length; i += 2) {
                if (!this.attrs[i].equals(key)) continue;
                return true;
            }
            return false;
        }

        public boolean isEqual(AttributeSet attr) {
            return attr != null && attr.containsAttributes(this) && this.containsAttributes(attr);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("[StyleContext.SmallattributeSet:");
            for (int i = 0; i < this.attrs.length; ++i) {
                sb.append(" (");
                sb.append(this.attrs[i].toString());
                sb.append("=");
                sb.append(this.attrs[i + 1].toString());
                sb.append(")");
            }
            sb.append("]");
            return sb.toString();
        }
    }

    public class NamedStyle
    implements Serializable,
    Style {
        private /* synthetic */ StyleContext this$0;
        protected ChangeEvent changeEvent;
        protected EventListenerList listenerList;
        AttributeSet attributes;
        String name;

        public NamedStyle(StyleContext this$0) {
            this.this$0 = this$0;
            this(this$0, null, null);
        }

        public NamedStyle(StyleContext this$0, Style parent) {
            this.this$0 = this$0;
            this(this$0, null, parent);
        }

        public NamedStyle(StyleContext this$0, String name, Style parent) {
            this.this$0 = this$0;
            this.name = name;
            this.attributes = this$0.getEmptySet();
            this.changeEvent = new ChangeEvent(this);
            this.listenerList = new EventListenerList();
            this.setResolveParent(parent);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String n) {
            this.name = n;
            this.fireStateChanged();
        }

        public void addChangeListener(ChangeListener l) {
            this.listenerList.add(StyleContext.class$("javax.swing.event.ChangeListener"), l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.listenerList.remove(StyleContext.class$("javax.swing.event.ChangeListener"), l);
        }

        public EventListener[] getListeners(Class listenerType) {
            return this.listenerList.getListeners(listenerType);
        }

        public ChangeListener[] getChangeListeners() {
            return (ChangeListener[])this.getListeners(StyleContext.class$("javax.swing.event.ChangeListener"));
        }

        protected void fireStateChanged() {
            ChangeListener[] listeners = this.getChangeListeners();
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].stateChanged(this.changeEvent);
            }
        }

        public void addAttribute(Object name, Object value) {
            this.attributes = this.this$0.addAttribute(this.attributes, name, value);
            this.fireStateChanged();
        }

        public void addAttributes(AttributeSet attr) {
            this.attributes = this.this$0.addAttributes(this.attributes, attr);
            this.fireStateChanged();
        }

        public boolean containsAttribute(Object name, Object value) {
            return this.attributes.containsAttribute(name, value);
        }

        public boolean containsAttributes(AttributeSet attrs) {
            return this.attributes.containsAttributes(attrs);
        }

        public AttributeSet copyAttributes() {
            return this.attributes.copyAttributes();
        }

        public Object getAttribute(Object attrName) {
            return this.attributes.getAttribute(attrName);
        }

        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        public Enumeration getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        public boolean isDefined(Object attrName) {
            return this.attributes.isDefined(attrName);
        }

        public boolean isEqual(AttributeSet attr) {
            return this.attributes.isEqual(attr);
        }

        public void removeAttribute(Object name) {
            this.attributes = this.this$0.removeAttribute(this.attributes, name);
            this.fireStateChanged();
        }

        public void removeAttributes(AttributeSet attrs) {
            this.attributes = this.this$0.removeAttributes(this.attributes, attrs);
            this.fireStateChanged();
        }

        public void removeAttributes(Enumeration names) {
            this.attributes = this.this$0.removeAttributes(this.attributes, names);
            this.fireStateChanged();
        }

        public AttributeSet getResolveParent() {
            return this.attributes.getResolveParent();
        }

        public void setResolveParent(AttributeSet parent) {
            this.attributes = this.this$0.addAttribute(this.attributes, AttributeSet.ResolveAttribute, parent);
            this.fireStateChanged();
        }

        public String toString() {
            return "[NamedStyle: name=" + this.name + ", attrs=" + this.attributes.toString() + "]";
        }
    }
}

