/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;

public class Utilities {
    private static final int BUF_LENGTH = 64;

    public static final int drawTabbedText(Segment s, int x, int y, Graphics g, TabExpander e, int startOffset) {
        char[] buffer = s.array;
        int pixelX = x;
        int pixelY = y;
        FontMetrics metrics = g.getFontMetrics();
        int ascent = metrics.getAscent();
        block4: for (int offset = s.offset; offset < s.offset + s.count; ++offset) {
            switch (buffer[offset]) {
                case '\t': {
                    if (e != null) {
                        pixelX = (int)e.nextTabStop(pixelX, startOffset + offset - s.offset);
                        continue block4;
                    }
                    pixelX += metrics.charWidth(' ');
                    continue block4;
                }
                case '\n': {
                    g.drawChars(buffer, offset, 1, pixelX, y);
                    pixelY += metrics.getHeight();
                    pixelX = x;
                    continue block4;
                }
                default: {
                    g.drawChars(buffer, offset, 1, pixelX, pixelY + ascent);
                    pixelX += metrics.charWidth(buffer[offset]);
                }
            }
        }
        return pixelX;
    }

    public static final int getTabbedTextWidth(Segment s, FontMetrics metrics, int x, TabExpander e, int startOffset) {
        char[] buffer = s.array;
        int pixelX = x;
        int maxWidth = 0;
        block4: for (int offset = s.offset; offset < s.offset + s.count; ++offset) {
            switch (buffer[offset]) {
                case '\t': {
                    if (e != null) {
                        pixelX = (int)e.nextTabStop(pixelX, startOffset + offset - s.offset);
                        continue block4;
                    }
                    pixelX += metrics.charWidth(' ');
                    continue block4;
                }
                case '\n': {
                    maxWidth = Math.max(maxWidth, (pixelX += metrics.charWidth(buffer[offset])) - x);
                    pixelX = x;
                    continue block4;
                }
                default: {
                    pixelX += metrics.charWidth(buffer[offset]);
                }
            }
        }
        maxWidth = Math.max(maxWidth, pixelX - x);
        return maxWidth;
    }
}

