/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.SwingConstants;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ViewFactory;

public abstract class View
implements SwingConstants {
    public static final int BadBreakWeight = 0;
    public static final int ExcellentBreakWeight = 2000;
    public static final int ForcedBreakWeight = 3000;
    public static final int GoodBreakWeight = 1000;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private float width;
    private float height;
    private Element elt;
    private View parent;

    public View(Element elem) {
        this.elt = elem;
    }

    public abstract void paint(Graphics var1, Shape var2);

    public void setParent(View a) {
        this.parent = a;
    }

    public View getParent() {
        return this.parent;
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public Container getContainer() {
        if (this.parent != null) {
            return this.parent.getContainer();
        }
        return null;
    }

    public Document getDocument() {
        return this.getElement().getDocument();
    }

    public Element getElement() {
        return this.elt;
    }

    public abstract float getPreferredSpan(int var1);

    public float getAlignment(int axis) {
        return 0.5f;
    }

    public AttributeSet getAttributes() {
        return this.elt.getAttributes();
    }

    public boolean isVisible() {
        return true;
    }

    public int getViewCount() {
        return 0;
    }

    public View getView(int index) {
        return null;
    }

    public ViewFactory getViewFactory() {
        if (this.parent != null) {
            return this.parent.getViewFactory();
        }
        return null;
    }

    public void replace(int offset, int length, View[] views) {
    }

    public void insert(int offset, View view) {
        View[] array = new View[]{view};
        this.replace(offset, 1, array);
    }

    public void append(View view) {
        View[] array = new View[]{view};
        this.replace(this.getViewCount(), 1, array);
    }

    public void removeAll() {
        this.replace(0, this.getViewCount(), null);
    }

    public void remove(int index) {
        this.replace(index, 1, null);
    }

    public View createFragment(int p0, int p1) {
        return this;
    }

    public int getStartOffset() {
        return this.elt.getStartOffset();
    }

    public int getEndOffset() {
        return this.elt.getEndOffset();
    }

    public Shape getChildAllocation(int index, Shape a) {
        return null;
    }

    public int getViewIndex(float x, float y, Shape allocation) {
        return -1;
    }

    public String getToolTipText(float x, float y, Shape allocation) {
        int index = this.getViewIndex(x, y, allocation);
        if (index < -1) {
            return null;
        }
        Shape childAllocation = this.getChildAllocation(index, allocation);
        if (childAllocation.getBounds().contains(x, y)) {
            return this.getView(index).getToolTipText(x, y, childAllocation);
        }
        return null;
    }
}

