/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.DataEnvironment;
import com.sleepycat.bdb.DataThang;
import com.sleepycat.bdb.util.RuntimeExceptionWrapper;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.Dbc;
import java.util.ArrayList;
import java.util.List;

public class DataDb {
    public static final int ENOMEM = 12;
    public static final int EINVAL = 22;
    public static final int FLAGS_POS_MASK = 255;
    public static final int FLAGS_MOD_MASK = -256;
    DataEnvironment env;
    Db db;
    int type;
    boolean ordered;
    private ThreadLocal cdbContext;
    private String file;
    private String database;
    boolean recNumAccess;
    boolean keysRenumbered;
    boolean dupsAllowed;
    boolean dupsOrdered;
    boolean transactional;
    boolean dirtyReadAllowed;

    public DataDb(Db db) {
        try {
            this.env = DataEnvironment.getEnvironment(db.getDbEnv());
            this.file = db.getFileName();
            this.database = db.getDatabaseName();
            this.db = db;
            this.type = db.getDbType();
            this.ordered = this.type == 1 || this.type == 4 || this.type == 3;
            this.recNumAccess = this.type != 2 && (this.type != 1 || (db.getFlags() & Db.DB_RECNUM) != 0);
            this.keysRenumbered = this.type == 3 && (db.getFlags() & Db.DB_RENUMBER) != 0;
            this.dupsOrdered = (db.getFlags() & Db.DB_DUPSORT) != 0;
            this.dupsAllowed = this.dupsOrdered || (db.getFlags() & Db.DB_DUP) != 0;
            this.dirtyReadAllowed = (db.getOpenFlags() & Db.DB_DIRTY_READ) != 0;
            boolean bl = this.transactional = this.env.isTxnMode() && db.isTransactional();
            if (this.env.isCdbMode()) {
                this.cdbContext = new ThreadLocal();
                this.cdbContext.set(new CdbThreadContext(this));
            }
        }
        catch (DbException dbException) {
            throw new RuntimeExceptionWrapper(dbException);
        }
    }

    public void close() throws DbException {
        this.db.close(0);
    }

    public final DataEnvironment getEnv() {
        return this.env;
    }

    public final Db getDb() {
        return this.db;
    }

    public final boolean isOrdered() {
        return this.ordered;
    }

    public final boolean areDuplicatesAllowed() {
        return this.dupsAllowed;
    }

    public final boolean areDuplicatesOrdered() {
        return this.dupsOrdered;
    }

    public final boolean areKeysRenumbered() {
        return this.keysRenumbered;
    }

    public final boolean hasRecNumAccess() {
        return this.recNumAccess;
    }

    public final boolean isTransactional() {
        return this.transactional;
    }

    public final boolean isDirtyReadAllowed() {
        return this.dirtyReadAllowed;
    }

    public int get(DataThang dataThang, DataThang dataThang2, int n) throws DbException {
        int n2 = n & 0xFF;
        if (this.cdbContext != null) {
            int n3;
            Dbc dbc = this.openCursor(n == Db.DB_CONSUME || n == Db.DB_CONSUME_WAIT);
            try {
                if (n2 == 0) {
                    n |= Db.DB_SET;
                }
                n3 = this.get(dbc, dataThang, dataThang2, n);
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.closeCursor(dbc);
                throw throwable;
            }
            this.closeCursor(dbc);
            return n3;
        }
        if (this.isRecnoKeyNonPositive(n2, dataThang)) {
            int n4 = -30990;
            return n4;
        }
        int n5 = this.db.get(this.currentTxn(), dataThang, dataThang2, n);
        return n5;
    }

    public int get(Dbc dbc, DataThang dataThang, DataThang dataThang2, int n) throws DbException {
        int n2 = n & 0xFF;
        if (this.isRecnoKeyNonPositive(n2, dataThang)) {
            return -30990;
        }
        int n3 = dbc.get(dataThang, dataThang2, n);
        return n3;
    }

    private boolean isRecnoKeyNonPositive(int n, DataThang dataThang) {
        return !(n != Db.DB_SET_RECNO && (this.type != 3 && this.type != 4 || n != Db.DB_SET && n != Db.DB_SET_RANGE && n != Db.DB_GET_BOTH) || dataThang.get_recno_key_data() > 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int put(DataThang dataThang, DataThang dataThang2, int n) throws DbException {
        int n2;
        DbTxn dbTxn;
        int n3;
        if (this.cdbContext != null && (this.type == 2 || this.type == 1)) {
            int n4;
            Dbc dbc;
            block16: {
                int n5;
                block15: {
                    dbc = this.openCursor(true);
                    try {
                        int n6 = n & 0xFF;
                        if (n6 == Db.DB_NODUPDATA && !this.areDuplicatesOrdered()) {
                            if (this.areDuplicatesAllowed()) {
                                int n7 = this.get(dbc, dataThang, dataThang2, Db.DB_GET_BOTH);
                                if (n7 == 0) {
                                    n5 = -30996;
                                    Object var8_11 = null;
                                    break block15;
                                }
                                n6 = 0;
                            } else {
                                n6 = Db.DB_NOOVERWRITE;
                            }
                            n = n6 | n & 0xFFFFFF00;
                        }
                        n4 = this.put(dbc, dataThang, dataThang2, n);
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        this.closeCursor(dbc);
                        throw throwable;
                    }
                }
                this.closeCursor(dbc);
                return n5;
            }
            Object var8_12 = null;
            this.closeCursor(dbc);
            return n4;
        }
        if (this.cdbContext != null) {
            CdbThreadContext cdbThreadContext = (CdbThreadContext)this.cdbContext.get();
            if (cdbThreadContext.writeCursors.size() > 0) {
                throw new IllegalStateException("cannot put() with CDB write cursor open");
            }
            if (cdbThreadContext.readCursors.size() > 0) {
                throw new IllegalStateException("cannot put() with CDB write cursor open");
            }
        }
        if ((n3 = n & 0xFF) == Db.DB_NODUPDATA && !this.areDuplicatesOrdered()) {
            if (this.areDuplicatesAllowed()) {
                int n8 = this.get(dataThang, dataThang2, Db.DB_GET_BOTH);
                if (n8 == 0) {
                    return -30996;
                }
                n3 = 0;
            } else {
                n3 = Db.DB_NOOVERWRITE;
            }
            n = n3 | n & 0xFFFFFF00;
        }
        if ((dbTxn = this.currentTxn()) == null) {
            n2 = this.db.put(dbTxn, dataThang, dataThang2, n);
            if (this.transactional) return n2;
        }
        n &= ~Db.DB_AUTO_COMMIT;
        return n2;
    }

    public int put(Dbc dbc, DataThang dataThang, DataThang dataThang2, int n) throws DbException {
        int n2;
        if (n == Db.DB_CURRENT && this.areDuplicatesOrdered()) {
            DataThang dataThang3 = new DataThang();
            dbc.get(dataThang, dataThang3, n);
            if (dataThang2.equals(dataThang3)) {
                return 0;
            }
            throw new IllegalArgumentException("Current data differs from put data with sorted duplicates");
        }
        if (n == Db.DB_NOOVERWRITE) {
            n2 = dbc.get(dataThang, DataThang.getDiscardDataThang(), Db.DB_SET | this.env.getWriteLockFlag());
            if (n2 == 0) {
                return -30996;
            }
            if (n2 != -30990) {
                return n2;
            }
            n = 0;
        }
        if (n == 0) {
            n = this.areDuplicatesOrdered() ? Db.DB_NODUPDATA : Db.DB_KEYLAST;
        }
        n2 = dbc.put(dataThang, dataThang2, n);
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int delete(DataThang dataThang, int n) throws DbException {
        int n2;
        Dbc dbc;
        block4: {
            int n3;
            block3: {
                dbc = this.openCursor(true);
                try {
                    int n4 = dbc.get(dataThang, DataThang.getDiscardDataThang(), Db.DB_SET | this.env.getWriteLockFlag());
                    if (n4 == 0) {
                        n3 = dbc.delete(0);
                        Object var6_7 = null;
                        break block3;
                    }
                    n2 = n4;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    this.closeCursor(dbc);
                    throw throwable;
                }
            }
            this.closeCursor(dbc);
            return n3;
        }
        Object var6_8 = null;
        this.closeCursor(dbc);
        return n2;
    }

    public Dbc openCursor(boolean bl) throws DbException {
        if (this.cdbContext != null) {
            Dbc dbc;
            int n;
            List list;
            CdbThreadContext cdbThreadContext = (CdbThreadContext)this.cdbContext.get();
            if (bl) {
                list = cdbThreadContext.writeCursors;
                n = Db.DB_WRITECURSOR;
                if (cdbThreadContext.readCursors.size() > 0) {
                    throw new IllegalStateException("cannot open CDB write cursor when read cursor is open");
                }
            } else {
                list = cdbThreadContext.readCursors;
                n = 0;
            }
            if (list.size() > 0) {
                Dbc dbc2 = (Dbc)list.get(0);
                dbc = dbc2.dup(0);
            } else {
                dbc = this.db.cursor(null, n);
            }
            list.add(dbc);
            return dbc;
        }
        return this.db.cursor(this.currentTxn(), 0);
    }

    public Dbc dupCursor(Dbc dbc, boolean bl, int n) throws DbException {
        if (this.cdbContext != null) {
            List list;
            CdbThreadContext cdbThreadContext = (CdbThreadContext)this.cdbContext.get();
            List list2 = list = bl ? cdbThreadContext.writeCursors : cdbThreadContext.readCursors;
            if (!list.contains(dbc)) {
                throw new IllegalStateException("cursor to dup not tracked");
            }
            Dbc dbc2 = dbc.dup(n);
            list.add(dbc2);
            return dbc2;
        }
        return dbc.dup(n);
    }

    public void closeCursor(Dbc dbc) throws DbException {
        if (dbc == null) {
            return;
        }
        if (this.cdbContext != null) {
            CdbThreadContext cdbThreadContext = (CdbThreadContext)this.cdbContext.get();
            if (!cdbThreadContext.readCursors.remove(dbc) && !cdbThreadContext.writeCursors.remove(dbc)) {
                throw new IllegalStateException("closing CDB cursor that was not known to be open");
            }
        }
        dbc.close();
    }

    private final DbTxn currentTxn() {
        if (this.transactional) {
            return this.env.getTxn();
        }
        return null;
    }

    public String toString() {
        String string = this.file;
        if (this.database != null) {
            this.file = this.file + new StringBuffer().append(' ').append(this.database);
        }
        return DataDb.toString(this, string);
    }

    static String toString(Object object, String string) {
        int n;
        String string2 = null;
        if (object != null && (n = (string2 = object.getClass().getName()).lastIndexOf(46)) >= 0) {
            string2 = string2.substring(n + 1);
        }
        return "[" + string2 + ' ' + string + ']';
    }

    private static final class CdbThreadContext {
        private DataDb db;
        private List writeCursors;
        private List readCursors;

        private /* synthetic */ void finit$() {
            this.writeCursors = new ArrayList();
            this.readCursors = new ArrayList();
        }

        CdbThreadContext(DataDb dataDb) {
            this.finit$();
            this.db = dataDb;
        }
    }
}

