/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.CurrentTransaction;
import com.sleepycat.bdb.util.RuntimeExceptionWrapper;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import java.util.WeakHashMap;

class DataEnvironment
extends CurrentTransaction {
    private static WeakHashMap envMap = new WeakHashMap();
    private int writeLockFlag;
    private boolean cdbMode;
    private boolean txnMode;
    private ThreadLocal currentTrans;

    private /* synthetic */ void finit$() {
        this.currentTrans = new ThreadLocal();
    }

    public static DataEnvironment getEnvironment(DbEnv dbEnv) {
        WeakHashMap weakHashMap = envMap;
        synchronized (weakHashMap) {
            try {
                DataEnvironment dataEnvironment = (DataEnvironment)envMap.get(dbEnv);
                if (dataEnvironment == null) {
                    dataEnvironment = new DataEnvironment(dbEnv);
                    envMap.put(dbEnv, dataEnvironment);
                }
                DataEnvironment dataEnvironment2 = dataEnvironment;
                Object var4_4 = null;
                return dataEnvironment2;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    private DataEnvironment(DbEnv dbEnv) {
        super(dbEnv);
        this.finit$();
        try {
            boolean bl = this.txnMode = (dbEnv.getOpenFlags() & Db.DB_INIT_TXN) != 0;
            if (this.txnMode || (dbEnv.getOpenFlags() & Db.DB_INIT_LOCK) != 0) {
                this.writeLockFlag = Db.DB_RMW;
            }
            this.cdbMode = (dbEnv.getOpenFlags() & Db.DB_INIT_CDB) != 0;
        }
        catch (DbException dbException) {
            throw new RuntimeExceptionWrapper(dbException);
        }
    }

    public final boolean isTxnMode() {
        return this.txnMode;
    }

    public final boolean isCdbMode() {
        return this.cdbMode;
    }

    public final int getWriteLockFlag() {
        return this.writeLockFlag;
    }
}

