/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.DataDb;
import com.sleepycat.bdb.DataThang;
import com.sleepycat.bdb.KeyRangeException;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import com.sleepycat.db.Dbc;

final class KeyRange {
    private static final int EINVAL = 22;
    private DataThang beginKey;
    private DataThang endKey;
    private boolean isSingleKey;
    private boolean isCursorValid;

    public KeyRange() {
    }

    public KeyRange(DataThang dataThang) {
        this.beginKey = dataThang;
        this.isSingleKey = true;
    }

    public KeyRange(DataThang dataThang, boolean bl, DataThang dataThang2, boolean bl2) {
        if (dataThang != null) {
            this.beginKey = dataThang;
            if (!bl) {
                this.beginKey.increment();
            }
        }
        if (dataThang2 != null) {
            this.endKey = dataThang2;
            if (bl2) {
                this.endKey.increment();
            }
        }
    }

    public KeyRange(KeyRange keyRange) {
        this.beginKey = keyRange.beginKey;
        this.endKey = keyRange.endKey;
        this.isSingleKey = keyRange.isSingleKey;
    }

    public KeyRange subRange(DataThang dataThang) throws KeyRangeException {
        if (!this.check(dataThang)) {
            throw new KeyRangeException("singleKey out of range");
        }
        return new KeyRange(dataThang);
    }

    public KeyRange subRange(DataThang dataThang, boolean bl, DataThang dataThang2, boolean bl2) throws KeyRangeException {
        KeyRange keyRange = new KeyRange(dataThang, bl, dataThang2, bl2);
        if (keyRange.beginKey == null) {
            keyRange.beginKey = this.beginKey;
        } else if (!this.check(keyRange.beginKey)) {
            throw new KeyRangeException("beginKey out of range");
        }
        if (keyRange.endKey == null) {
            keyRange.endKey = this.endKey;
        } else if (!this.checkRangeEnd(keyRange.endKey)) {
            throw new KeyRangeException("endKey out of range");
        }
        return keyRange;
    }

    public final DataThang getSingleKey() {
        if (this.isSingleKey) {
            return this.beginKey;
        }
        return null;
    }

    final boolean hasBound() {
        return this.isSingleKey || this.endKey != null || this.beginKey != null;
    }

    public String toString() {
        return "[KeyRange " + this.beginKey + ' ' + this.endKey + (this.isSingleKey ? " single" : "");
    }

    public boolean check(DataThang dataThang) {
        if (this.isSingleKey) {
            return dataThang.compareTo(this.beginKey) == 0;
        }
        if (this.beginKey != null && dataThang.compareTo(this.beginKey) < 0) {
            return false;
        }
        return this.endKey == null || dataThang.compareTo(this.endKey) < 0;
    }

    private boolean checkRangeEnd(DataThang dataThang) {
        if (this.isSingleKey) {
            return dataThang.compareTo(this.beginKey) == 0;
        }
        if (this.beginKey != null && dataThang.compareTo(this.beginKey) < 0) {
            return false;
        }
        return this.endKey == null || dataThang.compareTo(this.endKey) <= 0;
    }

    public int get(DataDb dataDb, Dbc dbc, DataThang dataThang, DataThang dataThang2, int n) throws DbException {
        int n2;
        if (this.beginKey == null && this.endKey == null) {
            return dataDb.get(dbc, dataThang, dataThang2, n);
        }
        int n3 = n & 0xFFFFFF00;
        int n4 = n2 = n & 0xFF;
        int n5 = 0;
        boolean bl = this.isCursorValid ^ true;
        if (n2 == Db.DB_CURRENT || n2 == Db.DB_NEXT_DUP) {
            if (bl) {
                this.throwInvalid(dataThang, dataThang2);
            }
            n5 = dataDb.get(dbc, dataThang, dataThang2, n2 | n3);
        } else if (n2 == Db.DB_SET || n2 == Db.DB_SET_RANGE || n2 == Db.DB_SET_RECNO || n2 == Db.DB_GET_BOTH) {
            if (n2 != Db.DB_SET_RANGE && !this.check(dataThang)) {
                n5 = this.setInvalid(dataThang, dataThang2);
            } else {
                n5 = dataDb.get(dbc, dataThang, dataThang2, n2 | n3);
                if (n5 == 0 && n2 == Db.DB_SET_RANGE && !this.check(dataThang)) {
                    n5 = this.setInvalid(dataThang, dataThang2);
                }
            }
        } else if (n2 == Db.DB_FIRST || n2 == Db.DB_NEXT || n2 == Db.DB_NEXT_NODUP) {
            if (bl) {
                n2 = Db.DB_FIRST;
            }
            if (this.isSingleKey) {
                if (n2 == Db.DB_NEXT_NODUP) {
                    n5 = -30990;
                } else if (n2 == Db.DB_FIRST) {
                    dataThang.copy(this.beginKey);
                    n5 = dataDb.get(dbc, dataThang, dataThang2, Db.DB_SET | n3);
                } else {
                    n5 = dataDb.get(dbc, dataThang, dataThang2, Db.DB_NEXT_DUP | n3);
                }
            } else {
                if (this.beginKey == null) {
                    n5 = dataDb.get(dbc, dataThang, dataThang2, n2 | n3);
                } else if (n2 == Db.DB_FIRST) {
                    dataThang.copy(this.beginKey);
                    n5 = dataDb.get(dbc, dataThang, dataThang2, Db.DB_SET_RANGE | n3);
                } else {
                    n5 = dataDb.get(dbc, dataThang, dataThang2, n2 | n3);
                }
                if (n5 == 0 && !this.check(dataThang)) {
                    if (n2 == Db.DB_FIRST) {
                        n5 = this.setInvalid(dataThang, dataThang2);
                    } else {
                        n5 = dataDb.get(dbc, dataThang, dataThang2, n2 == Db.DB_NEXT_NODUP ? Db.DB_PREV_NODUP : Db.DB_PREV);
                        if (n5 != 0) {
                            throw new DbException("Range internal error", n5);
                        }
                        n5 = -30990;
                    }
                }
            }
        } else if (n2 == Db.DB_LAST || n2 == Db.DB_PREV || n2 == Db.DB_PREV_NODUP) {
            if (bl) {
                n2 = Db.DB_LAST;
            }
            if (this.isSingleKey) {
                if (n2 == Db.DB_PREV_NODUP) {
                    n5 = -30990;
                } else if (this.endKey == null) {
                    this.endKey = new DataThang(this.beginKey);
                    this.endKey.increment();
                }
            }
            if (n5 == 0) {
                if (this.endKey == null) {
                    n5 = dataDb.get(dbc, dataThang, dataThang2, n2 | n3);
                } else if (n2 == Db.DB_LAST) {
                    dataThang.copy(this.endKey);
                    n5 = dataDb.get(dbc, dataThang, dataThang2, Db.DB_SET_RANGE | n3);
                    n5 = n5 == 0 ? dataDb.get(dbc, dataThang, dataThang2, (n4 == Db.DB_PREV_NODUP ? Db.DB_PREV_NODUP : Db.DB_PREV) | n3) : dataDb.get(dbc, dataThang, dataThang2, Db.DB_LAST | n3);
                } else {
                    n5 = dataDb.get(dbc, dataThang, dataThang2, n2 | n3);
                }
            }
            if (n5 == 0 && this.beginKey != null) {
                int n6 = dataThang.compareTo(this.beginKey);
                if (this.isSingleKey ? n6 != 0 : n6 < 0) {
                    if (n2 == Db.DB_LAST) {
                        n5 = this.setInvalid(dataThang, dataThang2);
                    } else {
                        n5 = dataDb.get(dbc, dataThang, dataThang2, n2 == Db.DB_PREV_NODUP ? Db.DB_NEXT_NODUP : Db.DB_NEXT);
                        if (n5 != 0) {
                            throw new DbException("Range internal error", n5);
                        }
                        n5 = -30990;
                    }
                }
            }
        } else if (n2 == Db.DB_CONSUME) {
            n5 = dataDb.get(dbc, dataThang, dataThang2, n);
        } else {
            throw new DbException("Unsupported flag", 22);
        }
        if (n5 == 0) {
            this.isCursorValid = true;
        }
        return n5;
    }

    private void throwInvalid(DataThang dataThang, DataThang dataThang2) throws DbException {
        this.setInvalid(dataThang, dataThang2);
        throw new DbException("Cursor not initialized", 22);
    }

    private int setInvalid(DataThang dataThang, DataThang dataThang2) {
        this.isCursorValid = false;
        if (dataThang != null) {
            dataThang.set_size(0);
        }
        if (dataThang2 != null) {
            dataThang2.set_size(0);
        }
        return -30990;
    }
}

