/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.CurrentTransaction;
import com.sleepycat.bdb.TransactionWorker;
import com.sleepycat.bdb.util.ExceptionUnwrapper;
import com.sleepycat.db.DbDeadlockException;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbTxn;

public class TransactionRunner {
    private static final int DEFAULT_MAX_RETRIES = 10;
    private DbEnv env;
    private CurrentTransaction currentTxn;
    private int maxRetries;
    private boolean dirtyRead;
    private boolean noWait;

    public TransactionRunner(DbEnv dbEnv) {
        this(dbEnv, 10);
    }

    public TransactionRunner(DbEnv dbEnv, int n) {
        this.env = dbEnv;
        this.currentTxn = CurrentTransaction.getInstance(dbEnv);
        this.maxRetries = n;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int n) {
        this.maxRetries = n;
    }

    public boolean getDirtyRead() {
        return this.dirtyRead;
    }

    public void setDirtyRead(boolean bl) {
        this.dirtyRead = bl;
    }

    public boolean getNoWait() {
        return this.noWait;
    }

    public void setNoWait(boolean bl) {
        this.noWait = bl;
    }

    public void run(TransactionWorker transactionWorker) throws DbException, Exception {
        if (this.currentTxn != null) {
            boolean bl = this.dirtyRead;
            boolean bl2 = this.noWait;
            int n = 0;
            while (true) {
                DbTxn dbTxn = null;
                try {
                    dbTxn = this.currentTxn.beginTxn(bl, bl2);
                    transactionWorker.doWork();
                    if (dbTxn != null && dbTxn == this.currentTxn.getTxn()) {
                        this.currentTxn.commitTxn();
                    }
                    return;
                }
                catch (Exception exception) {
                    Exception exception2 = ExceptionUnwrapper.unwrap(exception);
                    if (dbTxn != null && dbTxn == this.currentTxn.getTxn()) {
                        try {
                            this.currentTxn.abortTxn();
                        }
                        catch (Exception exception3) {
                            System.err.println(exception3.toString());
                            throw exception2;
                        }
                    }
                    if (n >= this.maxRetries || !(exception2 instanceof DbDeadlockException)) {
                        throw exception2;
                    }
                    ++n;
                    continue;
                }
                break;
            }
        }
        try {
            transactionWorker.doWork();
        }
        catch (Exception exception) {
            throw ExceptionUnwrapper.unwrap(exception);
        }
    }
}

