/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.tuple;

import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.DataBuffer;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import java.io.IOException;

public abstract class TupleBinding
implements DataBinding {
    protected TupleFormat format;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TupleBinding(TupleFormat tupleFormat) {
        this.format = tupleFormat;
    }

    public Object dataToObject(DataBuffer dataBuffer) throws IOException {
        return this.dataToObject(this.format.dataToInput(dataBuffer));
    }

    public void objectToData(Object object, DataBuffer dataBuffer) throws IOException {
        TupleOutput tupleOutput = this.format.newOutput();
        this.objectToData(object, tupleOutput);
        this.format.outputToData(tupleOutput, dataBuffer);
    }

    public DataFormat getDataFormat() {
        return this.format;
    }

    public abstract Object dataToObject(TupleInput var1) throws IOException;

    public abstract void objectToData(Object var1, TupleOutput var2) throws IOException;

    public static TupleBinding getPrimitiveBinding(Class clazz, TupleFormat tupleFormat) {
        if (clazz == TupleBinding.class$("java.lang.String")) {
            return new StringBinding(tupleFormat);
        }
        if (clazz == TupleBinding.class$("java.lang.Character")) {
            return new CharacterBinding(tupleFormat);
        }
        if (clazz == TupleBinding.class$("java.lang.Boolean")) {
            return new BooleanBinding(tupleFormat);
        }
        if (clazz == TupleBinding.class$("java.lang.Byte")) {
            return new ByteBinding(tupleFormat);
        }
        if (clazz == TupleBinding.class$("java.lang.Short")) {
            return new ShortBinding(tupleFormat);
        }
        if (clazz == TupleBinding.class$("java.lang.Integer")) {
            return new IntegerBinding(tupleFormat);
        }
        if (clazz == TupleBinding.class$("java.lang.Long")) {
            return new LongBinding(tupleFormat);
        }
        if (clazz == TupleBinding.class$("java.lang.Float")) {
            return new FloatBinding(tupleFormat);
        }
        if (clazz == TupleBinding.class$("java.lang.Double")) {
            return new DoubleBinding(tupleFormat);
        }
        return null;
    }

    private static class DoubleBinding
    extends TupleBinding {
        public DoubleBinding(TupleFormat tupleFormat) {
            super(tupleFormat);
        }

        public Object dataToObject(TupleInput tupleInput) throws IOException {
            return new Double(tupleInput.readDouble());
        }

        public void objectToData(Object object, TupleOutput tupleOutput) throws IOException {
            tupleOutput.writeDouble(((Number)object).doubleValue());
        }
    }

    private static class FloatBinding
    extends TupleBinding {
        public FloatBinding(TupleFormat tupleFormat) {
            super(tupleFormat);
        }

        public Object dataToObject(TupleInput tupleInput) throws IOException {
            return new Float(tupleInput.readFloat());
        }

        public void objectToData(Object object, TupleOutput tupleOutput) throws IOException {
            tupleOutput.writeFloat(((Number)object).floatValue());
        }
    }

    private static class LongBinding
    extends TupleBinding {
        public LongBinding(TupleFormat tupleFormat) {
            super(tupleFormat);
        }

        public Object dataToObject(TupleInput tupleInput) throws IOException {
            return new Long(tupleInput.readLong());
        }

        public void objectToData(Object object, TupleOutput tupleOutput) throws IOException {
            tupleOutput.writeLong(((Number)object).longValue());
        }
    }

    private static class IntegerBinding
    extends TupleBinding {
        public IntegerBinding(TupleFormat tupleFormat) {
            super(tupleFormat);
        }

        public Object dataToObject(TupleInput tupleInput) throws IOException {
            return new Integer(tupleInput.readInt());
        }

        public void objectToData(Object object, TupleOutput tupleOutput) throws IOException {
            tupleOutput.writeInt(((Number)object).intValue());
        }
    }

    private static class ShortBinding
    extends TupleBinding {
        public ShortBinding(TupleFormat tupleFormat) {
            super(tupleFormat);
        }

        public Object dataToObject(TupleInput tupleInput) throws IOException {
            return new Short(tupleInput.readShort());
        }

        public void objectToData(Object object, TupleOutput tupleOutput) throws IOException {
            tupleOutput.writeShort(((Number)object).shortValue());
        }
    }

    private static class ByteBinding
    extends TupleBinding {
        public ByteBinding(TupleFormat tupleFormat) {
            super(tupleFormat);
        }

        public Object dataToObject(TupleInput tupleInput) throws IOException {
            return new Byte(tupleInput.readByte());
        }

        public void objectToData(Object object, TupleOutput tupleOutput) throws IOException {
            tupleOutput.writeByte(((Number)object).byteValue());
        }
    }

    private static class BooleanBinding
    extends TupleBinding {
        public BooleanBinding(TupleFormat tupleFormat) {
            super(tupleFormat);
        }

        public Object dataToObject(TupleInput tupleInput) throws IOException {
            return new Boolean(tupleInput.readBoolean());
        }

        public void objectToData(Object object, TupleOutput tupleOutput) throws IOException {
            tupleOutput.writeBoolean((Boolean)object);
        }
    }

    private static class CharacterBinding
    extends TupleBinding {
        public CharacterBinding(TupleFormat tupleFormat) {
            super(tupleFormat);
        }

        public Object dataToObject(TupleInput tupleInput) throws IOException {
            return new Character(tupleInput.readChar());
        }

        public void objectToData(Object object, TupleOutput tupleOutput) throws IOException {
            tupleOutput.writeChar(((Character)object).charValue());
        }
    }

    private static class StringBinding
    extends TupleBinding {
        public StringBinding(TupleFormat tupleFormat) {
            super(tupleFormat);
        }

        public Object dataToObject(TupleInput tupleInput) throws IOException {
            return tupleInput.readString();
        }

        public void objectToData(Object object, TupleOutput tupleOutput) throws IOException {
            tupleOutput.writeString((String)object);
        }
    }
}

