/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.tuple;

import com.sleepycat.bdb.bind.tuple.TupleOutput;
import com.sleepycat.bdb.util.FastInputStream;
import com.sleepycat.bdb.util.UtfOps;
import java.io.EOFException;
import java.io.IOException;

public class TupleInput
extends FastInputStream {
    public TupleInput(byte[] byArray) {
        super(byArray);
    }

    public TupleInput(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
    }

    public TupleInput(TupleOutput tupleOutput) {
        super(tupleOutput.getBufferBytes(), tupleOutput.getBufferOffset(), tupleOutput.getBufferLength());
    }

    public final String readString() throws IOException {
        byte[] byArray = this.getBufferBytes();
        int n = this.getBufferOffset();
        int n2 = UtfOps.getZeroTerminatedByteLength(byArray, n);
        this.skip(n2 + 1);
        return UtfOps.bytesToString(byArray, n, n2);
    }

    public final char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public final byte readByte() throws IOException {
        byte by = (byte)this.readUnsignedByte();
        by = by < 0 ? (by &= 0x7F) : (by |= 0xFFFFFF80);
        return by;
    }

    public final short readShort() throws IOException {
        short s = (short)this.readUnsignedShort();
        s = s < 0 ? (s &= Short.MAX_VALUE) : (s |= Short.MIN_VALUE);
        return s;
    }

    public final int readInt() throws IOException {
        int n = (int)this.readUnsignedInt();
        n = n < 0 ? (n &= Integer.MAX_VALUE) : (n |= Integer.MIN_VALUE);
        return n;
    }

    public final long readLong() throws IOException {
        long l = this.readUnsignedLong();
        l = l < 0L ? (l &= Long.MAX_VALUE) : (l |= Long.MIN_VALUE);
        return l;
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat((int)this.readUnsignedInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readUnsignedLong());
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return n2 << 8 | n;
    }

    public final long readUnsignedInt() throws IOException {
        long l;
        long l2;
        long l3;
        long l4 = this.read();
        if ((l4 | (l3 = (long)this.read()) | (l2 = (long)this.read()) | (l = (long)this.read())) < 0L) {
            throw new EOFException();
        }
        return l4 << 24 | l3 << 16 | l2 << 8 | l;
    }

    private final long readUnsignedLong() throws IOException {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8 = this.read();
        if ((l8 | (l7 = (long)this.read()) | (l6 = (long)this.read()) | (l5 = (long)this.read()) | (l4 = (long)this.read()) | (l3 = (long)this.read()) | (l2 = (long)this.read()) | (l = (long)this.read())) < 0L) {
            throw new EOFException();
        }
        return l8 << 56 | l7 << 48 | l6 << 40 | l5 << 32 | l4 << 24 | l3 << 16 | l2 << 8 | l;
    }

    public final String readBytes(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            int n2 = this.read();
            if (n2 < 0) {
                throw new EOFException();
            }
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public final String readChars(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.readChar());
        }
        return stringBuffer.toString();
    }

    public final void readBytes(char[] cArray) throws IOException {
        for (int i = 0; i < cArray.length; ++i) {
            int n = this.read();
            if (n < 0) {
                throw new EOFException();
            }
            cArray[i] = (char)n;
        }
    }

    public final void readChars(char[] cArray) throws IOException {
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = this.readChar();
        }
    }

    public final String readString(int n) throws IOException {
        char[] cArray = new char[n];
        this.readString(cArray);
        return new String(cArray);
    }

    public final void readString(char[] cArray) throws IOException {
        byte[] byArray = this.getBufferBytes();
        this.off = UtfOps.bytesToChars(byArray, this.off, cArray, 0, cArray.length, false);
    }
}

