/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.collection.StoredContainer;
import com.sleepycat.bdb.collection.StoredIterator;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class StoredCollection
extends StoredContainer
implements Collection {
    StoredCollection(DataView dataView) {
        super(dataView);
    }

    final boolean add(Object object, Object object2) {
        boolean bl = this.beginAutoCommit();
        try {
            int n = this.view.put(object, object2, Db.DB_NODUPDATA, null);
            this.commitAutoCommit(bl);
            return n == 0;
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    public Iterator iterator() {
        return this.iterator(this.isWriteAllowed());
    }

    public StoredIterator iterator(boolean bl) {
        try {
            return new StoredIterator(this, bl && this.isWriteAllowed(), null);
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    public Object[] toArray() {
        Object[] objectArray;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            objectArray = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            StoredIterator.close(iterator);
            throw throwable;
        }
        StoredIterator.close(iterator);
        objectArray = arrayList.toArray();
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        Object[] objectArray2;
        Iterator iterator;
        block5: {
            int n = 0;
            iterator = this.iterator();
            try {
                while (n < objectArray.length && iterator.hasNext()) {
                    objectArray[n++] = iterator.next();
                }
                if (n < objectArray.length) {
                    objectArray[n] = null;
                    break block5;
                }
                if (!iterator.hasNext()) break block5;
                objectArray2 = new ArrayList(Arrays.asList(objectArray));
                while (iterator.hasNext()) {
                    objectArray2.add(iterator.next());
                }
                objectArray = objectArray2.toArray(objectArray);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                StoredIterator.close(iterator);
                throw throwable;
            }
        }
        objectArray2 = null;
        StoredIterator.close(iterator);
        objectArray2 = objectArray;
        return objectArray2;
    }

    public boolean containsAll(Collection collection) {
        boolean bl;
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                if (this.contains(iterator.next())) continue;
                bl = false;
                Object var4_5 = null;
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            StoredIterator.close(iterator);
            throw throwable;
        }
        {
            StoredIterator.close(iterator);
            return bl;
        }
        Object var4_6 = null;
        StoredIterator.close(iterator);
        boolean bl2 = true;
        return bl2;
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = null;
        boolean bl = this.beginAutoCommit();
        try {
            iterator = collection.iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                if (!this.add(iterator.next())) continue;
                bl2 = true;
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl);
            return bl2;
        }
        catch (Exception exception) {
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl);
        }
    }

    public boolean removeAll(Collection collection) {
        return this.removeAll(collection, true);
    }

    public boolean retainAll(Collection collection) {
        return this.removeAll(collection, false);
    }

    private boolean removeAll(Collection collection, boolean bl) {
        Iterator iterator = null;
        boolean bl2 = this.beginAutoCommit();
        try {
            boolean bl3 = false;
            iterator = this.iterator();
            while (iterator.hasNext()) {
                if (bl != collection.contains(iterator.next())) continue;
                iterator.remove();
                bl3 = true;
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl2);
            return bl3;
        }
        catch (Exception exception) {
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        boolean bl;
        Iterator iterator;
        block5: {
            boolean bl2;
            block4: {
                if (!(object instanceof Collection)) {
                    return false;
                }
                Collection collection = StoredCollection.copyCollection(object);
                iterator = this.iterator();
                try {
                    while (iterator.hasNext()) {
                        if (collection.remove(iterator.next())) continue;
                        bl2 = false;
                        Object var5_7 = null;
                        break block4;
                    }
                    bl = collection.isEmpty();
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    StoredIterator.close(iterator);
                    throw throwable;
                }
            }
            StoredIterator.close(iterator);
            return bl2;
        }
        Object var5_8 = null;
        StoredIterator.close(iterator);
        return bl;
    }

    public List toList() {
        ArrayList arrayList;
        ArrayList arrayList2 = new ArrayList();
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                arrayList2.add(iterator.next());
            }
            arrayList = arrayList2;
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            StoredIterator.close(iterator);
            throw throwable;
        }
        StoredIterator.close(iterator);
        return arrayList;
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(iterator.next().toString());
            }
            stringBuffer.append(']');
            string = stringBuffer.toString();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            StoredIterator.close(iterator);
            throw throwable;
        }
        StoredIterator.close(iterator);
        return string;
    }

    public StoredIterator join(StoredContainer[] storedContainerArray, Object[] objectArray) {
        return this.join(storedContainerArray, objectArray, false);
    }

    public StoredIterator join(StoredContainer[] storedContainerArray, Object[] objectArray, boolean bl) {
        try {
            DataView[] dataViewArray = new DataView[storedContainerArray.length];
            for (int i = 0; i < storedContainerArray.length; ++i) {
                dataViewArray[i] = storedContainerArray[i].view;
            }
            DataCursor dataCursor = this.view.join(dataViewArray, objectArray, bl);
            return new StoredIterator(this, false, dataCursor);
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Object getFirstOrLast(boolean bl) {
        Object var4_5;
        DataCursor dataCursor = null;
        try {
            try {
                dataCursor = new DataCursor(this.view, false);
                int n = dataCursor.get(null, null, bl ? Db.DB_FIRST : Db.DB_LAST, false);
                if (n == 0) {
                    Object object = this.makeIteratorData(null, dataCursor);
                    Object var5_6 = null;
                    this.closeCursor(dataCursor);
                    return object;
                }
                var4_5 = null;
            }
            catch (Exception exception) {
                throw StoredContainer.convertException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.closeCursor(dataCursor);
            throw throwable;
        }
        Object var5_7 = null;
        this.closeCursor(dataCursor);
        return var4_5;
    }

    abstract Object makeIteratorData(StoredIterator var1, DataCursor var2) throws DbException, IOException;

    abstract boolean hasValues();

    boolean iterateDuplicates() {
        return true;
    }

    void checkIterAddAllowed() throws UnsupportedOperationException {
        if (!this.areDuplicatesAllowed()) {
            throw new UnsupportedOperationException("duplicates required");
        }
    }

    int getIndexOffset() {
        return 0;
    }

    private static Collection copyCollection(Object object) {
        if (object instanceof StoredCollection) {
            return ((StoredCollection)object).toList();
        }
        return new ArrayList((Collection)object);
    }
}

