/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.collection.StoredCollection;
import com.sleepycat.bdb.collection.StoredContainer;
import com.sleepycat.bdb.collection.StoredIterator;
import com.sleepycat.bdb.collection.StoredMapEntry;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StoredEntrySet
extends StoredCollection
implements Set {
    StoredEntrySet(DataView dataView) {
        super(dataView);
    }

    public boolean add(Object object) {
        Map.Entry entry = (Map.Entry)object;
        return this.add(entry.getKey(), entry.getValue());
    }

    public boolean remove(Object object) {
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)object;
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            int n = dataCursor.get(entry.getKey(), entry.getValue(), Db.DB_GET_BOTH, true);
            if (n == 0) {
                dataCursor.delete();
            }
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return n == 0;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    public boolean contains(Object object) {
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)object;
        DataCursor dataCursor = null;
        try {
            try {
                dataCursor = new DataCursor(this.view, false);
                int n = dataCursor.get(entry.getKey(), entry.getValue(), Db.DB_GET_BOTH, false);
                boolean bl = n == 0;
                Object var6_6 = null;
                this.closeCursor(dataCursor);
                return bl;
            }
            catch (Exception exception) {
                throw StoredContainer.convertException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.closeCursor(dataCursor);
            throw throwable;
        }
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.iterator();
        try {
            Object object2;
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(',');
                }
                object2 = object.getKey();
                Object v = object.getValue();
                if (object2 != null) {
                    stringBuffer.append(object2.toString());
                }
                stringBuffer.append('=');
                if (v == null) continue;
                stringBuffer.append(v.toString());
            }
            stringBuffer.append(']');
            object = stringBuffer.toString();
            object2 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            StoredIterator.close(iterator);
            throw throwable;
        }
        StoredIterator.close(iterator);
        return object;
    }

    Object makeIteratorData(StoredIterator storedIterator, DataCursor dataCursor) throws DbException, IOException {
        return new StoredMapEntry(dataCursor.getCurrentKey(), dataCursor.getCurrentValue(), this, storedIterator);
    }

    boolean hasValues() {
        return true;
    }
}

