/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.util;

import java.io.IOException;
import java.io.InputStream;

public class FastInputStream
extends InputStream {
    protected int len;
    protected int off;
    protected int mark;
    protected byte[] buf;

    public FastInputStream(byte[] byArray) {
        this.buf = byArray;
        this.len = byArray.length;
    }

    public FastInputStream(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.off = n;
        this.len = n2;
    }

    public int available() {
        return this.len - this.off;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this.mark = n;
    }

    public void reset() {
        this.off = this.mark;
    }

    public long skip(long l) {
        int n = (int)l;
        if (n + this.off > this.len) {
            n = this.len - this.off;
        }
        this.off += n;
        return n;
    }

    public int read() throws IOException {
        if (this.off < this.len) {
            return this.buf[this.off++] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.len - this.off;
        if (n3 <= 0) {
            return -1;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        for (int i = 0; i < n2; ++i) {
            byArray[n++] = this.buf[this.off++];
        }
        return n2;
    }

    public byte[] getBufferBytes() {
        return this.buf;
    }

    public int getBufferOffset() {
        return this.off;
    }

    public int getBufferLength() {
        return this.len;
    }
}

