/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.DataEnvironment;
import com.sleepycat.bdb.util.RuntimeExceptionWrapper;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbTxn;

public class CurrentTransaction {
    private DbEnv dbEnv;
    private ThreadLocal currentTrans;

    private /* synthetic */ void finit$() {
        this.currentTrans = new ThreadLocal();
    }

    public static CurrentTransaction getInstance(DbEnv dbEnv) {
        DataEnvironment dataEnvironment = DataEnvironment.getEnvironment(dbEnv);
        if (dataEnvironment.isTxnMode()) {
            return dataEnvironment;
        }
        return null;
    }

    CurrentTransaction(DbEnv dbEnv) {
        this.finit$();
        this.dbEnv = dbEnv;
    }

    public final DbEnv getEnv() {
        return this.dbEnv;
    }

    public final boolean isAutoCommit() {
        try {
            return (this.dbEnv.getFlags() & Db.DB_AUTO_COMMIT) != 0;
        }
        catch (DbException dbException) {
            throw new RuntimeExceptionWrapper(dbException);
        }
    }

    public final boolean isDirtyRead() {
        Trans trans = (Trans)this.currentTrans.get();
        if (trans != null) {
            return trans.dirtyRead;
        }
        return false;
    }

    public final boolean isNoWait() {
        Trans trans = (Trans)this.currentTrans.get();
        if (trans != null) {
            return trans.noWait;
        }
        return false;
    }

    public final DbTxn getTxn() {
        Trans trans = (Trans)this.currentTrans.get();
        if (trans != null) {
            return trans.txn;
        }
        return null;
    }

    public final DbTxn beginTxn() throws DbException {
        return this.beginTxn(false, false);
    }

    public final DbTxn beginTxn(boolean bl, boolean bl2) throws DbException {
        Trans trans;
        int n = 0;
        if (bl) {
            n |= Db.DB_DIRTY_READ;
        }
        if (bl2) {
            n |= Db.DB_TXN_NOWAIT;
        }
        if ((trans = (Trans)this.currentTrans.get()) != null) {
            if (trans.txn != null) {
                DbTxn dbTxn = trans.txn;
                trans = new Trans(trans, bl, bl2);
                trans.txn = this.dbEnv.txnBegin(dbTxn, n);
                this.currentTrans.set(trans);
            } else {
                trans.txn = this.dbEnv.txnBegin(null, n);
            }
        } else {
            trans = new Trans(null, bl, bl2);
            trans.txn = this.dbEnv.txnBegin(null, n);
            this.currentTrans.set(trans);
        }
        return trans.txn;
    }

    public final DbTxn commitTxn() throws DbException, IllegalStateException {
        Trans trans = (Trans)this.currentTrans.get();
        if (trans != null && trans.txn != null) {
            DbTxn dbTxn = this.closeTxn(trans);
            trans.txn.commit(0);
            return dbTxn;
        }
        throw new IllegalStateException("No transaction is active");
    }

    public final DbTxn abortTxn() throws DbException, IllegalStateException {
        Trans trans = (Trans)this.currentTrans.get();
        if (trans != null && trans.txn != null) {
            DbTxn dbTxn = this.closeTxn(trans);
            trans.txn.abort();
            return dbTxn;
        }
        throw new IllegalStateException("No transaction is active");
    }

    private DbTxn closeTxn(Trans trans) {
        this.currentTrans.set(trans.parent);
        if (trans.parent != null) {
            return trans.parent.txn;
        }
        return null;
    }

    private static class Trans {
        private DbTxn txn;
        private Trans parent;
        private boolean dirtyRead;
        private boolean noWait;

        private Trans(Trans trans, boolean bl, boolean bl2) {
            this.parent = trans;
            this.dirtyRead = bl;
            this.noWait = bl2;
        }
    }
}

