/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.bind.DataBuffer;
import com.sleepycat.db.Db;
import com.sleepycat.db.Dbt;
import java.io.ByteArrayInputStream;
import java.io.PrintStream;

public final class DataThang
extends Dbt
implements DataBuffer {
    private static DataThang discardDataThang;
    private Object formation;

    static DataThang getDiscardDataThang() {
        if (discardDataThang == null) {
            discardDataThang = new DataThang();
            discardDataThang.setFlags(Db.DB_DBT_USERMEM | Db.DB_DBT_PARTIAL);
            discardDataThang.set_data(new byte[0]);
        }
        return discardDataThang;
    }

    public DataThang() {
        this.setFlags(Db.DB_DBT_MALLOC);
    }

    public DataThang(byte[] byArray) {
        this();
        this.setBytes(byArray);
    }

    public DataThang(DataThang dataThang) {
        this();
        this.copy(dataThang);
    }

    public void copy(DataThang dataThang) {
        this.setBytes(dataThang.getBytes());
    }

    public void setBytes(byte[] byArray) {
        this.formation = null;
        this.set_data(byArray);
        this.set_offset(0);
        this.set_size(byArray != null ? byArray.length : 0);
    }

    public void setBytes(byte[] byArray, int n, int n2) {
        this.formation = null;
        this.set_data(byArray);
        this.set_offset(n);
        this.set_size(n2);
    }

    public byte[] getBytes() {
        byte[] byArray = this.get_data();
        if (byArray == null) {
            return null;
        }
        int n = this.get_size();
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, this.get_offset(), byArray2, 0, n);
        return byArray2;
    }

    public ByteArrayInputStream getByteStream() {
        return new ByteArrayInputStream(this.get_data(), this.get_offset(), this.get_size());
    }

    public void increment() {
        this.formation = null;
        byte[] byArray = this.get_data();
        int n = this.get_offset();
        int n2 = this.get_size();
        byte[] byArray2 = new byte[n2 + 1];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        for (int i = n + n2 - 1; i >= n; --i) {
            int n3 = 0xFF & byArray[i];
            if (n3 == 255) continue;
            byArray2[i] = (byte)n3 + 1;
            this.setBytes(byArray2, 0, n2);
            return;
        }
        this.setBytes(byArray2);
    }

    public int compareTo(Dbt dbt) {
        byte[] byArray = this.get_data();
        int n = this.get_offset();
        int n2 = this.get_size();
        byte[] byArray2 = dbt.get_data();
        int n3 = dbt.get_offset();
        int n4 = dbt.get_size();
        for (int i = 0; i < n2 && i < n4; ++i) {
            int n5 = 0xFF & byArray[n + i];
            int n6 = 0xFF & byArray2[n3 + i];
            if (n5 < n6) {
                return -1;
            }
            if (n5 <= n6) continue;
            return 1;
        }
        if (n2 < n4) {
            return -1;
        }
        if (n2 > n4) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Dbt dbt) {
        return this.compareTo(dbt) == 0;
    }

    public void dump(PrintStream printStream) {
        DataThang.dump(this, printStream);
    }

    public static void dump(Dbt dbt, PrintStream printStream) {
        printStream.print(' ');
        printStream.print(DataThang.toString(dbt));
        printStream.println();
    }

    public static String toString(Dbt dbt) {
        int n = dbt.get_offset() + dbt.get_size();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        byte[] byArray = dbt.get_data();
        for (int i = dbt.get_offset(); i < n; ++i) {
            String string = Integer.toHexString(byArray[i]);
            if (string.length() < 2) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(byArray[i]));
        }
        if (dbt.get_size() == 4) {
            stringBuffer.append(" (recno ");
            stringBuffer.append(dbt.get_recno_key_data());
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return DataThang.toString(this);
    }

    public void setData(byte[] byArray, int n, int n2) {
        this.formation = null;
        this.set_data(byArray);
        this.set_offset(n);
        this.set_size(n2);
    }

    public byte[] getDataBytes() {
        return this.get_data();
    }

    public int getDataOffset() {
        return this.get_offset();
    }

    public int getDataLength() {
        return this.get_size();
    }

    public void setDataFormation(Object object) {
        this.formation = object;
    }

    public Object getDataFormation() {
        return this.formation;
    }

    public void clearDataFormation() {
        this.formation = null;
    }
}

