/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.tuple;

import com.sleepycat.bdb.util.FastOutputStream;
import com.sleepycat.bdb.util.UtfOps;
import java.io.IOException;

public class TupleOutput
extends FastOutputStream {
    public TupleOutput() {
    }

    public TupleOutput(byte[] byArray) {
        super(byArray);
    }

    public final void writeBytes(String string) throws IOException {
        this.writeBytes(string.toCharArray());
    }

    public final void writeChars(String string) throws IOException {
        this.writeChars(string.toCharArray());
    }

    public final void writeString(String string) throws IOException {
        if (string != null) {
            this.writeString(string.toCharArray());
        }
        this.write(0);
    }

    public final void writeChar(int n) throws IOException {
        this.write((byte)(n >>> 8));
        this.write((byte)n);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public final void writeByte(int n) throws IOException {
        int n2 = n;
        n2 = n2 < 0 ? (n2 &= 0x7F) : (n2 |= 0xFFFFFF80);
        this.writeUnsignedByte(n2);
    }

    public final void writeShort(int n) throws IOException {
        int n2 = n;
        n2 = n2 < 0 ? (n2 &= Short.MAX_VALUE) : (n2 |= Short.MIN_VALUE);
        this.writeUnsignedShort(n2);
    }

    public final void writeInt(int n) throws IOException {
        n = n < 0 ? (n &= Integer.MAX_VALUE) : (n |= Integer.MIN_VALUE);
        this.writeUnsignedInt(n);
    }

    public final void writeLong(long l) throws IOException {
        l = l < 0L ? (l &= Long.MAX_VALUE) : (l |= Long.MIN_VALUE);
        this.writeUnsignedLong(l);
    }

    public final void writeFloat(float f) throws IOException {
        this.writeUnsignedInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeUnsignedLong(Double.doubleToLongBits(d));
    }

    public final void writeBytes(char[] cArray) throws IOException {
        for (int i = 0; i < cArray.length; ++i) {
            this.write((byte)cArray[i]);
        }
    }

    public final void writeChars(char[] cArray) throws IOException {
        for (int i = 0; i < cArray.length; ++i) {
            this.write((byte)(cArray[i] >>> 8));
            this.write((byte)cArray[i]);
        }
    }

    public final void writeString(char[] cArray) throws IOException {
        if (cArray.length == 0) {
            return;
        }
        int n = UtfOps.getByteLength(cArray);
        this.makeSpace(n);
        UtfOps.charsToBytes(cArray, 0, this.getBufferBytes(), this.getBufferLength(), cArray.length);
        this.addSize(n);
    }

    public final void writeUnsignedByte(int n) throws IOException {
        this.write(n);
    }

    public final void writeUnsignedShort(int n) throws IOException {
        this.write((byte)(n >>> 8));
        this.write((byte)n);
    }

    public final void writeUnsignedInt(long l) throws IOException {
        this.write((byte)(l >>> 24));
        this.write((byte)(l >>> 16));
        this.write((byte)(l >>> 8));
        this.write((byte)l);
    }

    private final void writeUnsignedLong(long l) throws IOException {
        this.write((byte)(l >>> 56));
        this.write((byte)(l >>> 48));
        this.write((byte)(l >>> 40));
        this.write((byte)(l >>> 32));
        this.write((byte)(l >>> 24));
        this.write((byte)(l >>> 16));
        this.write((byte)(l >>> 8));
        this.write((byte)l);
    }
}

