/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.KeyRangeException;
import com.sleepycat.bdb.RecordNumberFormat;
import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.DataBuffer;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.EntityBinding;
import com.sleepycat.bdb.collection.StoredCollection;
import com.sleepycat.bdb.collection.StoredContainer;
import com.sleepycat.bdb.collection.StoredIterator;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class StoredList
extends StoredCollection
implements List {
    private static final DataBinding DEFAULT_KEY_BINDING = new IndexKeyBinding(1);
    private int baseIndex;
    private boolean isSubList;

    private /* synthetic */ void finit$() {
        this.baseIndex = 1;
    }

    public StoredList(DataStore dataStore, DataBinding dataBinding, boolean bl) {
        super(new DataView(dataStore, null, DEFAULT_KEY_BINDING, dataBinding, null, bl));
        this.finit$();
    }

    public StoredList(DataStore dataStore, EntityBinding entityBinding, boolean bl) {
        super(new DataView(dataStore, null, DEFAULT_KEY_BINDING, null, entityBinding, bl));
        this.finit$();
    }

    public StoredList(DataIndex dataIndex, DataBinding dataBinding, boolean bl) {
        super(new DataView(null, dataIndex, DEFAULT_KEY_BINDING, dataBinding, null, bl));
        this.finit$();
    }

    public StoredList(DataIndex dataIndex, EntityBinding entityBinding, boolean bl) {
        super(new DataView(null, dataIndex, DEFAULT_KEY_BINDING, null, entityBinding, bl));
        this.finit$();
    }

    private StoredList(DataView dataView, int n) {
        super(dataView);
        this.finit$();
        this.baseIndex = n;
        this.isSubList = true;
    }

    public void add(int n, Object object) {
        this.checkIterAddAllowed();
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            int n2 = dataCursor.get(new Long(n), null, Db.DB_SET, false);
            if (n2 == 0) {
                dataCursor.put(null, object, Db.DB_BEFORE, null);
                this.closeCursor(dataCursor);
            } else {
                this.closeCursor(dataCursor);
                dataCursor = null;
                this.view.append(object, null, null);
            }
            this.commitAutoCommit(bl);
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    public boolean add(Object object) {
        this.checkIterAddAllowed();
        boolean bl = this.beginAutoCommit();
        try {
            this.view.append(object, null, null);
            this.commitAutoCommit(bl);
            return true;
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    public int append(Object object) {
        boolean bl = this.beginAutoCommit();
        try {
            Object[] objectArray = new Object[1];
            this.view.append(object, objectArray, null);
            this.commitAutoCommit(bl);
            return ((Number)objectArray[0]).intValue();
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    void checkIterAddAllowed() throws UnsupportedOperationException {
        if (this.isSubList) {
            throw new UnsupportedOperationException("cannot add to subList");
        }
        if (!this.view.getDb().areKeysRenumbered()) {
            throw new UnsupportedOperationException("requires renumbered keys");
        }
    }

    public boolean addAll(int n, Collection collection) {
        this.checkIterAddAllowed();
        DataCursor dataCursor = null;
        Iterator iterator = null;
        boolean bl = this.beginAutoCommit();
        try {
            iterator = collection.iterator();
            if (!iterator.hasNext()) {
                return false;
            }
            dataCursor = new DataCursor(this.view, true);
            int n2 = dataCursor.get(new Long(n), null, Db.DB_SET, false);
            if (n2 == 0) {
                while (iterator.hasNext()) {
                    dataCursor.put(null, iterator.next(), Db.DB_BEFORE, null);
                }
                this.closeCursor(dataCursor);
            } else {
                this.closeCursor(dataCursor);
                dataCursor = null;
                while (iterator.hasNext()) {
                    this.view.append(iterator.next(), null, null);
                }
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl);
            return true;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl);
        }
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public Object get(int n) {
        return super.get(new Long(n));
    }

    public int indexOf(Object object) {
        return this.indexOf(object, true);
    }

    public int lastIndexOf(Object object) {
        return this.indexOf(object, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int indexOf(Object object, boolean bl) {
        int n;
        DataCursor dataCursor = null;
        try {
            try {
                dataCursor = new DataCursor(this.view, false);
                int n2 = dataCursor.find(object, bl);
                if (n2 == 0) {
                    int n3 = dataCursor.getCurrentRecordNumber() - this.baseIndex;
                    Object var6_7 = null;
                    this.closeCursor(dataCursor);
                    return n3;
                }
                n = -1;
            }
            catch (Exception exception) {
                throw StoredContainer.convertException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.closeCursor(dataCursor);
            throw throwable;
        }
        Object var6_8 = null;
        this.closeCursor(dataCursor);
        return n;
    }

    int getIndexOffset() {
        return this.baseIndex;
    }

    public ListIterator listIterator() {
        return this.iterator(this.isWriteAllowed());
    }

    public ListIterator listIterator(int n) {
        StoredIterator storedIterator = this.iterator(this.isWriteAllowed());
        if (storedIterator.moveToIndex(n)) {
            return storedIterator;
        }
        storedIterator.close();
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }

    public Object remove(int n) {
        try {
            Object[] objectArray = new Object[1];
            this.removeKey(new Long(n), objectArray);
            return objectArray[0];
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException(illegalArgumentException.getMessage());
        }
    }

    public boolean remove(Object object) {
        return this.removeValue(object);
    }

    public Object set(int n, Object object) {
        try {
            return this.put(new Long(n), object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException(illegalArgumentException.getMessage());
        }
    }

    public List subList(int n, int n2) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        try {
            int n3 = this.baseIndex + n;
            return new StoredList(this.view.subView(new Long(n), true, new Long(n2), false, new IndexKeyBinding(n3)), n3);
        }
        catch (KeyRangeException keyRangeException) {
            throw new IndexOutOfBoundsException(keyRangeException.getMessage());
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        boolean bl;
        ListIterator listIterator;
        ListIterator listIterator2;
        block13: {
            boolean bl2;
            block12: {
                boolean bl3;
                block11: {
                    boolean bl4;
                    block10: {
                        boolean bl5;
                        block9: {
                            boolean bl6;
                            block8: {
                                if (!(object instanceof List)) {
                                    return false;
                                }
                                List list = (List)object;
                                listIterator2 = null;
                                listIterator = null;
                                try {
                                    listIterator2 = this.listIterator();
                                    listIterator = list.listIterator();
                                    while (listIterator2.hasNext()) {
                                        if (!listIterator.hasNext()) {
                                            bl6 = false;
                                            Object var8_13 = null;
                                            break block8;
                                        }
                                        if (listIterator2.nextIndex() != listIterator.nextIndex()) {
                                            bl5 = false;
                                            break block9;
                                        }
                                        Object e = listIterator2.next();
                                        Object e2 = listIterator.next();
                                        if (e == null) {
                                            if (e2 == null) continue;
                                            bl4 = false;
                                            break block10;
                                        }
                                        if (e.equals(e2)) continue;
                                        bl3 = false;
                                        break block11;
                                    }
                                    if (listIterator.hasNext()) {
                                        bl2 = false;
                                        break block12;
                                    }
                                    bl = true;
                                    break block13;
                                }
                                catch (Throwable throwable) {
                                    Object var8_19 = null;
                                    StoredIterator.close(listIterator2);
                                    StoredIterator.close(listIterator);
                                    throw throwable;
                                }
                            }
                            StoredIterator.close(listIterator2);
                            StoredIterator.close(listIterator);
                            return bl6;
                        }
                        Object var8_14 = null;
                        StoredIterator.close(listIterator2);
                        StoredIterator.close(listIterator);
                        return bl5;
                    }
                    Object var8_15 = null;
                    StoredIterator.close(listIterator2);
                    StoredIterator.close(listIterator);
                    return bl4;
                }
                Object var8_16 = null;
                StoredIterator.close(listIterator2);
                StoredIterator.close(listIterator);
                return bl3;
            }
            Object var8_17 = null;
            StoredIterator.close(listIterator2);
            StoredIterator.close(listIterator);
            return bl2;
        }
        Object var8_18 = null;
        StoredIterator.close(listIterator2);
        StoredIterator.close(listIterator);
        return bl;
    }

    Object makeIteratorData(StoredIterator storedIterator, DataCursor dataCursor) throws DbException, IOException {
        return dataCursor.getCurrentValue();
    }

    boolean hasValues() {
        return true;
    }

    private static class IndexKeyBinding
    implements DataBinding {
        private static RecordNumberFormat format = new RecordNumberFormat();
        private int baseIndex;

        private IndexKeyBinding(int n) {
            this.baseIndex = n;
        }

        public DataFormat getDataFormat() {
            return format;
        }

        public Object dataToObject(DataBuffer dataBuffer) throws IOException {
            return new Long(format.dataToRecordNumber(dataBuffer) - (long)this.baseIndex);
        }

        public void objectToData(Object object, DataBuffer dataBuffer) throws IOException {
            format.recordNumberToData(((Number)object).intValue() + this.baseIndex, dataBuffer);
        }
    }
}

