;; File: startup.el.in
;; Description: Emacsen startup for dictionaries-common in Debian
;; Author: Rafael Laboissire <rafael@debian.org>
;; Created on: Fri Oct 22 09:48:21 CEST 1999
;; Last modified on: Mon Feb 25 16:42:30 CET 2002

(debian-pkg-add-load-path-item
 (concat "/usr/share/"
	 (symbol-name debian-emacs-flavor)
	 "/site-lisp/dictionaries-common"))

(autoload 'debian-ispell-add-dictionary-entry "debian-ispell" nil t)
(autoload 'flyspell-mode "flyspell" nil t)
(autoload 'flyspell-prog-mode "flyspell" nil t)

;; Load the emacsen cache file, containing calls to
;; debian-ispell-add-dictionary-entry for each installed dictionary.
;; Since this might result in a call to debian-ispell do this only if 
;; it exists, that is, if package is not removed

(if (not (file-exists-p "/usr/share/emacs/site-lisp/dictionaries-common/debian-ispell.el"))
    (message "Info: Package dictionaries-common removed but not purged.")
  (load "/var/cache/dictionaries-common/emacsen-ispell-dicts.el" t))

;; This will force menu changes only for X called {x}emacs. To be loaded after
;; all dictionaries emacs stuff is loaded. ispell.el will be loaded at this time
;; 
;; * If you want ispell.el never be loaded at {x}emacs startup, comment lines 
;;   below. Note that spellchecking popup menus will not be correct until it is 
;;   loaded after issuing ispell-check specific commands.
;; * If you want it to be loaded always at both console or at X call, comment 
;;   everything below but the lines
;;      (setq ispell-menu-xemacs nil)
;;      (ispell-change-dictionary nil)
 
(if (or (eq window-system 'x) (eq window-system 'gtk))
    (progn
      (setq ispell-menu-xemacs nil)
      (ispell-change-dictionary nil)
      )
  )

;;Local Variables:
;;mode: lisp
;;End:

