# $Id: main.py 2051 2004-12-09 14:53:04Z fabbione $

# Copyright (C) 2000, 2001, 2003 Progeny Linux Systems, Inc.
# Authors: Branden Robinson; Jeff Licquia; Eric Gillespie
#
# This is free software; you may redistribute it and/or modify
# it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2,
# or (at your option) any later version.
#
# This is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License with
# the Debian operating system, in /usr/share/common-licenses/GPL;  if
# not, write to the Free Software Foundation, Inc., 59 Temple Place,
# Suite 330, Boston, MA 02111-1307 USA

# this is my first Python program, so please use lube (BR)

import configlet
import gettext
import re
import string
import os

TRUE = 1
FALSE = 0

#_cat = gettext.Catalog(PACKAGE, LOCALEDIR)
#_ = _cat.gettext
def _(s):
    return s

current_horiz_sync = ""
current_vert_refresh = ""
current_video_ram = ""
current_bus_id = ""
selection_method = ""

# XXX: The very EXISTENCE of this variable is a FOULNESS caused by IDIOCY on
# the part of the PyGTK+ author.  There is no Python access to
# GTK_WIDGET_SENSITIVE().  I was tempted to name this variable
# ZIPPY_THE_PINHEAD.
use_fbdev_widget_sensitive = FALSE

dexlet_attributes = { "name": "dexlet",
                      "display_title": "Configure the X Window System Server",
                      "description": "Select this option to configure video and input hardware to work with the X Window System.",
                      "page_names": [ "desktop_hbox_main",
                                      "videocard_hbox_main",
                                      "monitor_hbox_main",
                                      "pointer_hbox_main",
                                      "invocation_hbox_main" ],
                      "page_display_titles": { "desktop_hbox_main" : "Desktop",
                                               "videocard_hbox_main" : "Video Card",
                                               "monitor_hbox_main" : "Monitor",
                                               "pointer_hbox_main" : "Pointer",
                                               "invocation_hbox_main" : "Invocation Options" },
                      "shared_questions": ["shared/clobber_x-server_symlink",
                                           "shared/default-x-server",
                                           "shared/xfree86v3"],
                      "api_version": 2
}

color_depths_keys = [ "monochrome (1 bit)",
                      "16 colors (4 bits)",
                      "256 colors (8 bits)",
                      "32,768 colors (15 bits)",
                      "65,536 colors (16 bits)",
                      "16.7 million colors (24 bits)" ]

color_depths_values = [ "1", "4", "8", "15", "16", "24" ]

color_depths = { }
for i in range(len(color_depths_keys)):
    color_depths[color_depths_keys[i]] = color_depths_values[i]

bpp_choices = [ "8",
                "16",
                "24",
                "32" ]

card_drivers_keys = [ "Alliance",
                      "Ark Logic",
                      "ATI",
                      "Chips and Technologies",
                      "Cirrus Logic",
                      "Cyrix",
                      "Linux kernel framebuffer driver",
                      "3Dfx Voodoo Graphics / Voodoo2",
                      "3DLabs",
                      "Number Nine Imagine 128",
                      "Intel i740",
                      "Intel i810",
                      "IMS (Integrated Micro Solutions)",
                      "Matrox",
                      "NeoMagic MagicGraph",
                      "NVidia",
                      "Rendition",
                      "S3 ViRGE & Trio3D",
                      "S3 Savage",
                      "SMI (Silicon Motion, Inc.)",
                      "SiS (Silicon Integrated Systems)",
                      "3Dfx Voodoo Banshee / Voodoo3 / Voodoo4 / Voodoo5",
                      "DEC (Digital Equipment Corp.) TGA",
                      "Trident",
                      "Tseng Labs",
                      "generic VESA driver",
                      "generic VGA driver" ]

card_drivers_values = [ "apm",
                        "ark",
                        "ati",
                        "chips",
                        "cirrus",
                        "cyrix",
                        "fbdev",
                        "glide",
                        "glint",
                        "i128",
                        "i740",
                        "i810",
                        "imstt",
                        "mga",
                        "neomagic",
                        "nv",
                        "rendition",
                        "s3virge",
                        "savage",
                        "siliconmotion",
                        "sis",
                        "tdfx",
                        "tga",
                        "trident",
                        "tseng",
                        "vesa",
                        "vga" ]

card_drivers = { }
for i in range(len(card_drivers_keys)):
    card_drivers[card_drivers_keys[i]] = card_drivers_values[i]

arch_driver_map = { "alpha"     : ( "ati", "glint", "mga", "nv", "rendition",
                                    "s3virge", "siliconmotion", "tdfx", "tga",
                                    "vga" ),
                    "arm"       : ( "ati", "chips", "fbdev", "glint", "imstt",
                                    "mga", "s3virge", "savage", "tdfx",
                                    "trident", "vga" ),
                    "hurd-i386" : ( "apm", "ark", "ati", "chips", "cirrus",
                                    "cyrix", "fbdev", "glide", "glint", "i128",
                                    "i740", "i810", "imstt", "mga", "neomagic",
                                    "nv", "rendition", "s3virge", "savage",
                                    "siliconmotion", "sis", "tdfx", "tga",
                                    "trident", "tseng", "vesa", "vga" ),
                    "i386"      : ( "apm", "ark", "ati", "chips", "cirrus",
                                    "cyrix", "fbdev", "glide", "glint", "i128",
                                    "i740", "i810", "imstt", "mga", "neomagic",
                                    "nv", "rendition", "s3virge", "savage",
                                    "siliconmotion", "sis", "tdfx", "tga",
                                    "trident", "tseng", "vesa", "vga" ),
                    "ia64"      : ( "apm", "ark", "ati", "chips", "cirrus",
                                    "cyrix", "fbdev", "glint", "i128", "i740",
                                    "i810", "imstt", "mga", "neomagic", "nv",
                                    "rendition", "s3virge", "savage",
                                    "siliconmotion", "sis", "tdfx", "tga",
                                    "trident", "tseng", "vesa", "vga" ),
                    "hppa"      : ( "fbdev" ),
                    "m68k"      : ( "ati", "chips", "fbdev", "glint", "imstt",
                                    "mga", "s3virge", "savage", "sis", "tdfx",
                                    "trident", "vga" ),
                    "mips"      : ( "ati", "chips", "fbdev", "glint", "mga",
                                    "newport", "nv", "s3virge", "savage", "sis",
                                    "tdfx", "trident" ),
                    "mipsel"    : ( "ati", "chips", "fbdev", "glint", "mga",
                                    "newport", "nv", "s3virge", "savage", "sis",
                                    "tdfx", "trident" ),
                    "powerpc"   : ( "ati", "chips", "fbdev", "glint", "imstt",
                                    "mga", "s3virge", "savage", "sis", "tdfx",
                                    "trident", "vga" ),
                    "sparc"     : ( "ati", "fbdev", "glint", "sunbw2",
                                    "suncg14", "suncg3", "suncg6", "sunffb",
                                    "sunleo", "suntcx" ) }

screen_size_freqs_keys = [ "Up to 14 inches (355 mm)",
                           "15 inches (380 mm)",
                           "17 inches (430 mm)",
                           "19-20 inches (480-510 mm)",
                           "21 inches (530 mm) or more" ]

screen_size_freqs_values = [ "28-33 43-72",
                             "28-50 43-75",
                             "30-70 50-160",
                             "30-100 50-160",
                             "30-130 50-160" ]

screen_size_freqs = { }
for i in range(len(screen_size_freqs_keys)):
    screen_size_freqs[screen_size_freqs_keys[i]] = screen_size_freqs_values[i]

mode_list_freqs_keys = [ "640x480 @ 60Hz",
                         "640x480 @ 72Hz",
                         "800x600 @ 60Hz",
                         "800x600 @ 72Hz",
                         "800x600 @ 85Hz",
                         "1024x768 @ 60Hz",
                         "1024x768 @ 70Hz",
                         "1024x768 @ 75Hz",
                         "1152x864 @ 75Hz",
                         "1280x960 @ 60Hz",
                         "1280x960 @ 85Hz",
                         "1600x1200 @ 60Hz",
                         "1600x1200 @ 75Hz",
                         "1600x1200 @ 85Hz",
                         "1792x1344 @ 60Hz",
                         "1792x1344 @ 75Hz",
                         "1856x1392 @ 60Hz",
                         "1856x1392 @ 75Hz",
                         "1920x1440 @ 60Hz",
                         "1920x1440 @ 75Hz" ]

mode_list_freqs_values = [ "28-33 43-72",
                           "28-38 43-72",
                           "28-38 43-72",
                           "28-48 43-72",
                           "30-54 50-85",
                           "28-49 43-72",
                           "30-57 43-72",
                           "30-60 50-75",
                           "30-68 50-85",
                           "30-60 50-75",
                           "30-92 50-85",
                           "30-75 50-85",
                           "30-94 50-75",
                           "30-107 50-85",
                           "30-84 50-75",
                           "30-107 50-85",
                           "30-87 50-75",
                           "30-113 50-75",
                           "30-90 50-75",
                           "30-130 60-160" ]

mode_list_freqs = { }
for i in range(len(mode_list_freqs_keys)):
    mode_list_freqs[mode_list_freqs_keys[i]] = mode_list_freqs_values[i]

mouse_ports = [ ]

mouse_ports_devfs = [ "/dev/misc/psaux",
                      "/dev/tts/0",
                      "/dev/tts/1",
                      "/dev/tts/2",
                      "/dev/tts/3",
                      "/dev/input/mice",
                      "/dev/misc/atixl",
                      "/dev/gpmdata" ]

mouse_ports_traditional = [ "/dev/psaux",
                            "/dev/ttyS0",
                            "/dev/ttyS1",
                            "/dev/ttyS2",
                            "/dev/ttyS3",
                            "/dev/input/mice",
                            "/dev/atibm",
                            "/dev/sunmouse",
                            "/dev/gpmdata" ]

mouse_protocols = [ ]

mouse_protocols_psaux = [ "PS/2",
                          "ImPS/2",
                          "GlidePointPS/2",
                          "NetMousePS/2",
                          "NetScrollPS/2",
                          "ThinkingMousePS/2",
                          "MouseManPlusPS/2",
                          "ExplorerPS/2" ]

mouse_protocols_serial = [ "Auto",
                           "Microsoft",
                           "MouseSystems",
                           "GlidePoint",
                           "ThinkingMouse",
                           "MouseMan",
                           "Logitech",
                           "IntelliMouse",
                           "MMSeries",
                           "MMHitTab" ]

mouse_protocols_gpmdata = [ "Auto",
                            "BusMouse",
                            "ExplorerPS/2",
                            "GlidePoint",
                            "GlidePointPS/2",
                            "ImPS/2",
                            "IntelliMouse",
                            "Logitech",
                            "MMHitTab",
                            "MMSeries",
                            "Microsoft",
                            "MouseMan",
                            "MouseManPlusPS/2",
                            "MouseSystems",
                            "NetMousePS/2",
                            "NetScrollPS/2",
                            "PS/2",
                            "ThinkingMouse",
                            "ThinkingMousePS/2" ]

allowed_users_choices_keys = [ "Root Only",
                               "Console Users Only",
                               "Anybody" ]

allowed_users_choices_values = [ "rootonly",
                                 "console",
                                 "anybody" ]

# XXX: not used at present; for future reference
xservers = [ "xserver-3dlabs",
             "xserver-8514",
             "xserver-agx",
             "xserver-fbdev",
             "xserver-i128",
             "xserver-mach32",
             "xserver-mach64",
             "xserver-mach8",
             "xserver-mono",
             "xserver-p9000",
             "xserver-s3",
             "xserver-s3v",
             "xserver-svga",
             "xserver-tga",
             "xserver-vga16",
             "xserver-w32",
             "xserver-xfree86",
             "xserver-xsun",
             "xserver-xsun-mono",
             "xserver-xsun24" ]

dpkg_output = os.popen(r"dpkg --get-selections | awk '/xserver-.*install$/{print $1}' | grep -v common")
available_xservers = []
for line in dpkg_output.readlines():
    available_xservers.append(string.strip(line))
dpkg_output.close()
configlet.debug("dexlet",
                "available xservers: " + string.join(available_xservers, " "))
dexlet_attributes["packages"] = available_xservers + ["xserver-common"]

allowed_users_choices = { }
for i in range(len(allowed_users_choices_keys)):
    allowed_users_choices[allowed_users_choices_keys[i]] = allowed_users_choices_values[i]

def get_optionmenu_index(optionmenu):
    menu = optionmenu.get_menu()
    children = menu.get_children()
    item = menu.get_active()
    for i in range(len(children)):
        if children[i] == item:
            break
    return i

def select_xserver(menushell, selected_xserver):
    "callback function for use of X server selection widget"
    audit_server_dependent_widgets(selected_xserver)

def select_mouse_port(menushell, selected_mouse_port):
    "callback function for use of mouse port selection widget"
    audit_mouse_protocol_widget(selected_mouse_port)

def audit_server_dependent_widgets(selected_xserver):
    "enable/disable widgets dependent on which X server is selected"
    if selected_xserver == "xserver-xfree86":
        my_wtree.get_widget("device_driver").set_sensitive(TRUE)
        my_wtree.get_widget("default_depth").set_sensitive(TRUE)
        my_wtree.get_widget("default_bpp").set_sensitive(FALSE)
        my_wtree.get_widget("device_bus_id").set_sensitive(TRUE)
        audit_device_use_fbdev_state()
    elif selected_xserver == "xserver-3dlabs" or \
         selected_xserver == "xserver-8514"   or \
         selected_xserver == "xserver-agx"    or \
         selected_xserver == "xserver-fbdev"  or \
         selected_xserver == "xserver-i128"   or \
         selected_xserver == "xserver-mach32" or \
         selected_xserver == "xserver-mach64" or \
         selected_xserver == "xserver-mach8"  or \
         selected_xserver == "xserver-mono"   or \
         selected_xserver == "xserver-p9000"  or \
         selected_xserver == "xserver-s3"     or \
         selected_xserver == "xserver-s3v"    or \
         selected_xserver == "xserver-svga"   or \
         selected_xserver == "xserver-tga"    or \
         selected_xserver == "xserver-vga16"  or \
         selected_xserver == "xserver-w32":
        my_wtree.get_widget("device_driver").set_sensitive(FALSE)
        my_wtree.get_widget("default_depth").set_sensitive(FALSE)
        my_wtree.get_widget("default_bpp").set_sensitive(TRUE)
        my_wtree.get_widget("device_bus_id").set_sensitive(FALSE)
        audit_device_use_fbdev_state()
    else:
        # XXX: handle xserver-xsun* with a dialog, probably
        # (and gray out all other widgets?)
        raise RuntimeError, "impossible value of default_xserver widget"

def audit_mouse_protocol_widget(selected_mouse_port):
    global mouse_protocols
    if re.match(r'/dev.*/psaux', selected_mouse_port):
        new_protocol_list = mouse_protocols_psaux
    elif re.match(r'/dev/tt.*[0-3]', selected_mouse_port):
        new_protocol_list = mouse_protocols_serial
    elif selected_mouse_port == "/dev/input/mice":
        new_protocol_list = [ "ImPS/2" ]
    elif selected_mouse_port == "/dev/atibm" or \
         selected_mouse_port == "/dev/misc/atixl" or \
         selected_mouse_port == "/dev/sunmouse":
         new_protocol_list = [ "BusMouse" ]
    elif selected_mouse_port == "/dev/gpmdata":
        new_protocol_list = mouse_protocols_gpmdata
    else:
        configlet.warn("dexlet", "impossible value of selected_mouse_port; \"%s\"" % (selected_mouse_port,))
    mouse_protocols = new_protocol_list
    newmenu = gtk.Menu()
    for item in mouse_protocols:
        menuitem = gtk.MenuItem(item)
        menuitem.show()
        newmenu.append(menuitem)
    newmenu.show()
    # The option menu will automatically de-ref the old menu, so I don't need
    # to destroy it.
    my_wtree.get_widget("mouse_protocol").set_menu(newmenu)
    # If less than two choices in newmenu, make the optionmenu insensitive.
    if len(mouse_protocols) < 2:
        my_wtree.get_widget("mouse_protocol").set_sensitive(FALSE)
    else:
        my_wtree.get_widget("mouse_protocol").set_sensitive(TRUE)

def audit_monitor_simple_button_state(*args):
    if my_wtree.get_widget("monitor_lcd").get_active():
        my_wtree.get_widget("monitor_simple_button").set_sensitive(FALSE)
    else:
        my_wtree.get_widget("monitor_simple_button").set_sensitive(TRUE)

def audit_device_use_fbdev_state():
    if os.path.exists("/proc/fb"):
        my_wtree.get_widget("device_use_fbdev").set_sensitive(TRUE)
        use_fbdev_widget_sensitive = TRUE
    else:
        my_wtree.get_widget("device_use_fbdev").set_active(FALSE)
        my_wtree.get_widget("device_use_fbdev").set_sensitive(FALSE)
        use_fbdev_widget_sensitive = FALSE

def set_freqs(horiz_sync, vert_refresh):
    global current_horiz_sync, current_vert_refresh
    current_horiz_sync = horiz_sync
    current_vert_refresh = vert_refresh
    configlet.debug("dexlet", "current_horiz_sync set to %s, current_vert_refresh set to %s" % (current_horiz_sync, current_vert_refresh))
    my_wtree.get_widget("horiz_sync_label").set_text("Horizontal Sync: " + horiz_sync + " kHz")
    my_wtree.get_widget("vert_refresh_label").set_text("Vertical Refresh: " + vert_refresh + " Hz")
    my_wtree.get_widget("horiz_sync_entry").set_text(horiz_sync)
    my_wtree.get_widget("vert_refresh_entry").set_text(vert_refresh)

def raise_monitor_simple_dialog(*args):
    w = my_wtree.get_widget("monitor_simple_dialog")
    w.show()
    w.grab_focus()

def raise_monitor_medium_dialog(*args):
    w = my_wtree.get_widget("monitor_medium_dialog")
    w.show()
    w.grab_focus()

def raise_monitor_advanced_dialog(*args):
    w = my_wtree.get_widget("monitor_advanced_dialog")
    w.show()
    w.grab_focus()

def raise_videocard_advanced_dialog(*args):
    w = my_wtree.get_widget("videocard_advanced_dialog")
    w.show()
    w.grab_focus()

def freq_ok(freq):
    # returns 0 if input invalid, 1 if valid
    if freq == "" or re.search(r'[^0-9,. -]', freq):
        return 0
    else:
        return 1

def dialog_ok(*args):
    global current_horiz_sync, current_vert_refresh, current_video_ram, current_bus_id, selection_method
    this_dialog = args[-1]
    if this_dialog == "monitor_simple":
        selection_method = "Simple"
        i = get_optionmenu_index(my_wtree.get_widget("screen_size"))
        (horiz_sync, vert_refresh) = re.split(r'\s+', screen_size_freqs_values[i], 1)
        set_freqs(horiz_sync, vert_refresh)
    elif this_dialog == "monitor_medium":
        selection_method = "Medium"
        i = get_optionmenu_index(my_wtree.get_widget("mode_list"))
        (horiz_sync, vert_refresh) = re.split(r'\s+', mode_list_freqs_values[i], 1)
        set_freqs(horiz_sync, vert_refresh)
    elif this_dialog == "monitor_advanced":
        selection_method = "Advanced"
        horiz_sync = my_wtree.get_widget("horiz_sync_entry").get_text()
        vert_refresh = my_wtree.get_widget("vert_refresh_entry").get_text()
        if (not freq_ok(horiz_sync)) or (not freq_ok(vert_refresh)):
            dialog = gnome_ui.GnomeMessageBox("Invalid characters in frequency specification. If you\ncontinue, the information you have entered will be ignored.\n\nContinue?", \
                         "warning", gnome_ui.STOCK_BUTTON_YES, gnome_ui.STOCK_BUTTON_NO)
            dialog.set_position(gtk.WIN_POS_CENTER)
            discard_garbage = dialog.run_and_close()
            if discard_garbage == 0:
                # yes, close the dialog anyway, ignoring the bogus input
                horiz_sync = current_horiz_sync
                vert_refresh = current_vert_refresh
            elif discard_garbage == 1:
                # no, don't close the dialog; fix the bad input
                return
            else:
                # user closed dialog with window manager
                return
        set_freqs(horiz_sync, vert_refresh)
    elif this_dialog == "videocard_advanced":
        bus_id_entry = my_wtree.get_widget("device_bus_id")
        if bus_id_entry.get_text() != "":
            if re.match(r'^PCI:[0-9][0-9]?[0-9]?:[0-9][0-9]?:[0-9][0-9]?$', bus_id_entry.get_text()):
                # valid PCI specification
                pass
            elif re.match(r'^SBUS:\(0x[0-9A-Fa-f]+\)', bus_id_entry.get_text()):
                # valid SBUS specification
                pass
            elif re.match(r'-1', bus_id_entry.get_text()):
                # valid ISA/native bus(?) specification (kludge on XFree86's part)
                pass
            else:
                dialog = gnome_ui.GnomeMessageBox("Improperly formatted BusID specification. If you continue,\nthe information you have entered will be ignored.\n\nContinue?", \
                    "warning", gnome_ui.STOCK_BUTTON_YES, gnome_ui.STOCK_BUTTON_NO)
                dialog.set_position(gtk.WIN_POS_CENTER)
                discard_garbage = dialog.run_and_close()
                if discard_garbage == 0:
                    # yes, close the dialog anyway, ignoring the bogus input
                    bus_id_entry.set_text(current_bus_id)
                elif discard_garbage == 1:
                    # no, don't close the dialog; fix the bad input
                    return
                else:
                    # user closed dialog with window manager
                    return
        video_ram_entry = my_wtree.get_widget("device_video_ram")
        if video_ram_entry.get_text() != "" and re.search(r'[^0-9]', video_ram_entry.get_text()):
            dialog = gnome_ui.GnomeMessageBox("Invalid characters in video RAM specification. If you continue,\nthe information you have entered will be ignored.\n\nContinue?", \
                         "warning", gnome_ui.STOCK_BUTTON_YES, gnome_ui.STOCK_BUTTON_NO)
            dialog.set_position(gtk.WIN_POS_CENTER)
            discard_garbage = dialog.run_and_close()
            if discard_garbage == 0:
                # yes, close the dialog anyway, ignoring the bogus input
                video_ram_entry.set_text(current_video_ram)
            elif discard_garbage == 1:
                # no, don't close the dialog; fix the bad input
                return
            else:
                # user closed dialog with window manager
                return
    this_widget = my_wtree.get_widget(this_dialog + "_dialog")
    this_widget.hide()

def dialog_cancel(*args):
    this_dialog = args[-1]
    this_widget = my_wtree.get_widget(this_dialog + "_dialog")
    this_widget.hide()

def raise_32bits_dialog(*args):
    box_text = "32-bit color is actually 24 bits of color information plus\n8 bits of alpha channel or simple zero padding. The X Window\nSystem can handle both kinds of data, so select the 24 bit\nsetting if you need either alpha channel or zero padding."

    dialog = gtk.MessageDialog(None, 0, gtk.MESSAGE_INFO, gtk.BUTTONS_CLOSE,
                               box_text)
    dialog.set_position(gtk.WIN_POS_CENTER)
    dialog.run()
    dialog.destroy()

class Dexlet(configlet.Configlet):
    def append_debconf(self, name, value):
        self.debconf_data.append(name + ' ' + name + ' ' + value)

    def gnome_setup(self):
        configlet.Configlet.gnome_setup(self)

        global gnome_ui
        import gnome.ui
        gnome_ui = gnome.ui
        global gtk
        import gtk

        # here is where geometry fixups can happen if need be

        # give our callback functions above access to the widget tree
        global my_wtree

        my_wtree = self.wtree

        # connect the callback functions
        my_wtree.get_widget("monitor_simple_button").connect("clicked", raise_monitor_simple_dialog)
        my_wtree.get_widget("monitor_medium_button").connect("clicked", raise_monitor_medium_dialog)
        my_wtree.get_widget("monitor_advanced_button").connect("clicked", raise_monitor_advanced_dialog)

        my_wtree.get_widget("monitor_simple_ok_button").connect("clicked", dialog_ok, "monitor_simple")
        my_wtree.get_widget("monitor_medium_ok_button").connect("clicked", dialog_ok, "monitor_medium")
        my_wtree.get_widget("monitor_advanced_ok_button").connect("clicked", dialog_ok, "monitor_advanced")
        my_wtree.get_widget("monitor_simple_cancel_button").connect("clicked", dialog_cancel, "monitor_simple")
        my_wtree.get_widget("monitor_medium_cancel_button").connect("clicked", dialog_cancel, "monitor_medium")
        my_wtree.get_widget("monitor_advanced_cancel_button").connect("clicked", dialog_cancel, "monitor_advanced")

        my_wtree.get_widget("videocard_advanced_button").connect("clicked", raise_videocard_advanced_dialog)
        my_wtree.get_widget("videocard_advanced_ok_button").connect("clicked", dialog_ok, "videocard_advanced")
        my_wtree.get_widget("videocard_advanced_cancel_button").connect("clicked", dialog_cancel, "videocard_advanced")

        my_wtree.get_widget("about_32bits_button").connect("clicked", raise_32bits_dialog)

        my_wtree.get_widget("monitor_lcd").connect("toggled", audit_monitor_simple_button_state)

        # initialize the option menus

        # color depth
        newmenu = gtk.Menu()
        for item in color_depths_keys:
            menuitem = gtk.MenuItem(item)
            menuitem.show()
            newmenu.append(menuitem)
        newmenu.show()
        my_wtree.get_widget("default_depth").set_menu(newmenu)

        # bpp
        newmenu = gtk.Menu()
        for item in bpp_choices:
            menuitem = gtk.MenuItem(item)
            menuitem.show()
            newmenu.append(menuitem)
        newmenu.show()
        my_wtree.get_widget("default_bpp").set_menu(newmenu)

        # X server driver list
        # TODO: populate this using arch_driver_map
        newmenu = gtk.Menu()
        for item in card_drivers_keys:
            menuitem = gtk.MenuItem(item)
            menuitem.show()
            newmenu.append(menuitem)
        newmenu.show()
        my_wtree.get_widget("device_driver").set_menu(newmenu)

        # default X server
        #dpkg_output = os.popen(r"dpkg --get-selections | awk '/xserver-.*install$/{print $1}' | grep -v common")
        #temp_list = dpkg_output.readlines()
        #temp_list.sort()
        server_list = map(string.strip, available_xservers)
        newmenu = gtk.Menu()
        for item in server_list:
            menuitem = gtk.MenuItem(item)
            menuitem.show()
            menuitem.connect("activate", select_xserver, item)
            newmenu.append(menuitem)
        newmenu.show()
        my_wtree.get_widget("default_xserver").set_menu(newmenu)
        if len(server_list) < 2:
            my_wtree.get_widget("default_xserver").set_sensitive(FALSE)

        # allowed users
        newmenu = gtk.Menu()
        for item in allowed_users_choices_keys:
            menuitem = gtk.MenuItem(item)
            menuitem.show()
            newmenu.append(menuitem)
        newmenu.show()
        my_wtree.get_widget("allowed_users").set_menu(newmenu)

        # screen size
        newmenu = gtk.Menu()
        for item in screen_size_freqs_keys:
            label = gtk.Label(item)
            label.show()
            menuitem = gtk.MenuItem()
            menuitem.add(label)
            menuitem.show()
            newmenu.append(menuitem)
        newmenu.show()
        my_wtree.get_widget("screen_size").set_menu(newmenu)

        # mode list
        newmenu = gtk.Menu()
        for item in mode_list_freqs_keys:
            menuitem = gtk.MenuItem(item)
            menuitem.show()
            newmenu.append(menuitem)
        newmenu.show()
        my_wtree.get_widget("mode_list").set_menu(newmenu)

    def load_debconf(self, data):
        "set configlet widget state using debconf database values"
        global current_horiz_sync, current_vert_refresh, current_video_ram, current_bus_id, mouse_ports, selection_method
        # have to get current default X server first
        # assume 4.x unless we're told otherwise
        configspace = "xserver-xfree86"
        default_xserver = "xserver-xfree86"
        for template in data:
            (name, question, value) = re.split(r'\s+', template, 2)
            if name == "shared/default-x-server":
                audit_server_dependent_widgets(value)

        self.debug("default-x-server value from debconf is " + default_xserver)
        try:
            i = available_xservers.index(default_xserver)
        except ValueError, e:
            self.warn("default-x-server is %s, but could not find it in list of available X servers" % (default_xserver,))
            i = 0
        else:
            self.debug("found it in our list at index %d" % (i,))
        self.wtree.get_widget("default_xserver").set_history(i)

        # set widgets according to corresponding debconf db info
        for template in data:
            (name, question, value) = re.split(r'\s+', template, 2)
            if value == '""':
                value = ""

            # available modes
            if name == (configspace + "/config/display/modes"):
                self.debug("debconf config display modes are" + value)
                if value == "":
                    self.debug("was null, turning on all 4:3 modes")
                    value = "1920x1440, 1856x1392, 1792x1344, 1600x1200, 1280x960, 1152x864, 1024x768, 800x600, 640x480"
                modelist = re.split(r',\s*', value)
                for mode in ("1920x1440", "1856x1392", "1792x1344", "1600x1200", "1280x1024", "1280x960", "1152x864", "1024x768", "800x600", "640x480"):
                    if mode in modelist:
                        self.debug("mode_" + mode + " widget ON")
                        self.wtree.get_widget("mode_" + mode).set_active(TRUE)
                    else:
                        self.debug("mode_" + mode + " widget OFF")
                        self.wtree.get_widget("mode_" + mode).set_active(FALSE)

            # color depth
            elif name == (configspace + "/config/display/default_depth"):
                if value == "":
                    value = "24"
                # value will be 1, 4, 8, 15, 16, or 24
                self.debug("default_depth value from debconf is " + value)
                try:
                    i = color_depths_values.index(value)
                except ValueError, e:
                    self.warn("default_depth is %s, but could not find it in list of color depths" % (value,))
                    i = 0
                else:
                    self.debug("found it in our list at index %d -- now setting default_depth widget to that" % (i,))
                self.wtree.get_widget("default_depth").set_history(i)

            # bpp
            elif name == (configspace + "/config/display/default_bpp"):
                if value == "":
                    value = "24"
                # value will be 8, 16, 24, or 32
                self.debug("default_bpp value from debconf is " + value)
                try:
                    i = bpp_choices.index(value)
                except ValueError, e:
                    self.warn("default_bpp is %s, but could not find it in list of color depths" % (value,))
                else:
                    self.debug("found it in our list at index %d -- now setting default_bpp widget to that" % (i,))
                self.wtree.get_widget("default_bpp").set_history(i)

            # X server driver (inactive if 3.x)
            elif name == (configspace + "/config/device/driver"):
                if value == "":
                    value = "ati"
                self.debug("device driver value from debconf is " + value)
                try:
                    i = card_drivers_values.index(value)
                except ValueError, e:
                    self.warn("could not find device driver %s in list of available drivers" % (value,))
                    i = 0
                else:
                    self.debug("found it in our list at index %d" % (i,))
                self.wtree.get_widget("device_driver").set_history(i)

            # UseFBDev (inactive if 3.x)
            elif name == (configspace + "/config/device/use_fbdev"):
                audit_device_use_fbdev_state()
                if use_fbdev_widget_sensitive:
                    self.wtree.get_widget("device_use_fbdev").set_active(string.upper(value) == "TRUE")

            # BusID (inactive if 3.x)
            elif name == (configspace + "/config/device/bus_id"):
                self.wtree.get_widget("device_bus_id").set_text(value)
                current_bus_id = value

            # VideoRAM
            elif name == (configspace + "/config/device/video_ram"):
                self.wtree.get_widget("device_video_ram").set_text(value)
                current_video_ram = value

            # monitor is LCD
            elif name == (configspace + "/config/monitor/lcd"):
                if value == "":
                    value = "false"
                self.wtree.get_widget("monitor_lcd").set_active(string.upper(value) == "TRUE")

            # screen size
            elif name == (configspace + "/config/monitor/screen-size"):
                if value == "":
                    value = "17 inches (430 mm)"
                self.debug("monitor screen size value from debconf is" + value)
                try:
                    i = screen_size_freqs_keys.index(value)
                except ValueError, e:
                    self.warn("screen-size is %s, but could not find it in our list of screen sizes" % (value,))
                else:
                    self.debug("found it in our list at index %d" % (i,))
                self.wtree.get_widget("screen_size").set_history(i)

            # mode list
            elif name == (configspace + "/config/monitor/mode-list"):
                if value == "":
                    value = "1152x864 @ 75Hz"
                self.debug("monitor mode list value from debconf is " + value)
                try:
                    i = mode_list_freqs_keys.index(value)
                except ValueError, e:
                    self.warn("mode-list is %s, but could not find it in our list of modes" % (value,))
                    i = 0
                else:
                    self.debug("found it in our list at index %d" % (i,))
                self.wtree.get_widget("mode_list").set_history(i)

            # selection method
            elif name == (configspace + "/config/monitor/selection-method"):
                if value == "":
                    value = "Simple"
                selection_method = value

            # horizontal sync
            elif name == (configspace + "/config/monitor/horiz-sync"):
                if value == "":
                    value = "30-75"
                self.wtree.get_widget("horiz_sync_label").set_text("Horizontal Sync: " + value + " kHz")
                self.wtree.get_widget("horiz_sync_entry").set_text(value)
                current_horiz_sync = value

            # vertical refresh
            elif name == (configspace + "/config/monitor/vert-refresh"):
                if value == "":
                    value = "50-85"
                self.wtree.get_widget("vert_refresh_label").set_text("Vertical Refresh: " + value + " Hz")
                self.wtree.get_widget("vert_refresh_entry").set_text(value)
                current_vert_refresh = value

            # mouse port
            elif name == (configspace + "/config/inputdevice/mouse/port"):
                if os.path.exists("/dev/.devfsd"):
                    mouse_ports = mouse_ports_devfs
                else:
                    mouse_ports = mouse_ports_traditional
                newmenu = gtk.Menu()
                for item in mouse_ports:
                    menuitem = gtk.MenuItem(item)
                    menuitem.show()
                    menuitem.connect("activate", select_mouse_port, item)
                    newmenu.append(menuitem)
                newmenu.show()
                my_wtree.get_widget("mouse_port").set_menu(newmenu)
                self.debug("mouse port from debconf is " + value)
                try:
                    i = mouse_ports.index(value)
                except ValueError, e:
                    self.warn("mouse port is %s, but could not find it in our list of mouse ports" % (value,))
                    i = 0
                else:
                    self.debug("found it in our list at %d" % (i,))
                self.wtree.get_widget("mouse_port").set_history(i)
                # set the protocol list
                i = get_optionmenu_index(my_wtree.get_widget("mouse_port"))
                audit_mouse_protocol_widget(mouse_ports[i])

            # mouse protocol
            elif name == (configspace + "/config/inputdevice/mouse/protocol"):
                if value == "":
                    value = "PS/2"
                self.debug("mouse protocol from debconf is " + value)
                try:
                    i = mouse_protocols.index(value)
                except ValueError, e:
                    self.warn("mouse protocol is %s, but could not find it in our list of mouse protocols" % (value,))
                else:
                    self.debug("found it in our list at %d" % (i,))
                self.wtree.get_widget("mouse_protocol").set_history(i)

            # emulate 3 buttons
            elif name == (configspace + "/config/inputdevice/mouse/emulate3buttons"):
                if value == "":
                    value = "true"
                self.wtree.get_widget("emulate_3buttons").set_active(string.upper(value) == "TRUE")

            # scroll events
            elif name == (configspace + "/config/inputdevice/mouse/zaxismapping"):
                if value == "":
                    value = "true"
                self.wtree.get_widget("enable_scroll_wheel").set_active(string.upper(value) == "TRUE")

            # X server
            # already handled above
            elif name == "shared/default-x-server":
                pass

            # allowed users
            elif name == "xserver-common/xwrapper/actual_allowed_users":
                if value == "":
                    value = "console"
                self.debug("actual allowed users from debconf is " + value)
                try:
                    i = allowed_users_choices_values.index(value)
                except ValueError, e:
                    self.warn("actual_allowed_users is %s, but could not find it in our list of actual allowed users" % (value,))
                    i = 0
                else:
                    self.debug("found it in our list at index %d" % (i,))
                self.wtree.get_widget("allowed_users").set_history(i)

            # nice value
            elif name == "xserver-common/xwrapper/nice_value":
                if value == "":
                    value = "-10"
                try:
                    self.wtree.get_widget("nice_value").set_value(int(value))
                except ValueError, e:
                    self.warn("nice_value is %s, but this not an integer" % (value,))
                    self.wtree.get_widget("nice_value").set_value(-10)

            else:
                pass

    def validate_page(self, pagename):
        return 1

    def on_gnome_close(self):
        "collect and store configlet widget states"
        # default X server
        i = get_optionmenu_index(self.wtree.get_widget("default_xserver"))
        default_xserver = available_xservers[i]
        if default_xserver == "xserver-xfree86":
            configspace = default_xserver
        else:
            configspace = "shared/xfree86v3"

        # ACTUAL allowed users
        i = get_optionmenu_index(self.wtree.get_widget("allowed_users"))
        allowed_users = allowed_users_choices_keys[i]
        actual_allowed_users = allowed_users_choices_values[i]

        # nice value
        nice_value = self.wtree.get_widget("nice_value").get_value_as_int()

        # available modes
        temp = [ ]
        for mode in ("1920x1440", "1856x1392", "1792x1344", "1600x1200", "1280x1024", "1280x960", "1152x864", "1024x768", "800x600", "640x480"):
            if self.wtree.get_widget("mode_" + mode).get_active() == TRUE:
                temp.append(mode)
        modelist = string.join(temp, ", ")

        # color depth
        i = get_optionmenu_index(self.wtree.get_widget("default_depth"))
        color_depth = color_depths_values[i]

        # X server driver (set inactive if 3.x)
        if default_xserver == "xserver-xfree86":
            i = get_optionmenu_index(self.wtree.get_widget("device_driver"))
            xserver_driver = card_drivers_values[i]

        # UseFBDev
        if self.wtree.get_widget("device_use_fbdev").get_active() == TRUE:
            use_fbdev = "true"
        else:
            use_fbdev = "false"

        # BusID
        bus_id = string.strip(self.wtree.get_widget("device_bus_id").get_text())

        # VideoRAM
        video_ram = string.strip(self.wtree.get_widget("device_video_ram").get_text())

        # monitor is LCD
        if self.wtree.get_widget("monitor_lcd").get_active() == TRUE:
            monitor_lcd = "true"
        else:
            monitor_lcd = "false"

        # screen size
        i = get_optionmenu_index(self.wtree.get_widget("screen_size"))
        screen_size = screen_size_freqs_keys[i]

        # mode list
        i = get_optionmenu_index(self.wtree.get_widget("mode_list"))
        monitor_mode_list = mode_list_freqs_keys[i]

        # horizontal sync
        horiz_sync = current_horiz_sync

        # vertical refresh
        vert_refresh = current_vert_refresh

        # mouse port
        i = get_optionmenu_index(self.wtree.get_widget("mouse_port"))
        mouse_port = mouse_ports[i]

        # mouse protocol
        i = get_optionmenu_index(self.wtree.get_widget("mouse_protocol"))
        mouse_protocol = mouse_protocols[i]

        # emulate 3 buttons
        if self.wtree.get_widget("emulate_3buttons").get_active() == TRUE:
            emulate_3buttons = "true"
        else:
            emulate_3buttons = "false"

        # scroll events
        if self.wtree.get_widget("enable_scroll_wheel").get_active() == TRUE:
            zaxismapping = "true"
        else:
            zaxismapping = "false"

        self.debconf_data = [ ]

        self.append_debconf("shared/default-x-server", default_xserver)
        self.append_debconf("xserver-common/xwrapper/allowed_users", allowed_users)
        self.append_debconf("xserver-common/xwrapper/actual_allowed_users", actual_allowed_users)
        self.append_debconf("xserver-common/xwrapper/nice_value", "%d" % (nice_value,))
        self.append_debconf(configspace + "/config/device/identifier", "Generic Video Card")
        self.append_debconf(configspace + "/config/device/video_ram", video_ram)
        self.append_debconf(configspace + "/config/inputdevice/mouse/port", mouse_port)
        self.append_debconf(configspace + "/config/inputdevice/mouse/protocol", mouse_protocol)
        self.append_debconf(configspace + "/config/inputdevice/mouse/emulate3buttons", emulate_3buttons)
        self.append_debconf(configspace + "/config/inputdevice/mouse/zaxismapping", zaxismapping)
        self.append_debconf(configspace + "/config/monitor/identifier", "Generic Monitor")
        self.append_debconf(configspace + "/config/monitor/lcd", monitor_lcd)
        self.append_debconf(configspace + "/config/monitor/screen-size", screen_size)
        self.append_debconf(configspace + "/config/monitor/mode-list", monitor_mode_list)
        self.append_debconf(configspace + "/config/monitor/selection-method", selection_method)
        self.append_debconf(configspace + "/config/monitor/horiz-sync", horiz_sync)
        self.append_debconf(configspace + "/config/monitor/vert-refresh", vert_refresh)
        self.append_debconf(configspace + "/config/display/modes", modelist)
        self.append_debconf(configspace + "/config/display/default_depth", color_depth)

        if default_xserver == "xserver-xfree86":
            # if 4.x, append xserver_driver, use_fbdev, and bus_id
            self.append_debconf(configspace + "/config/device/driver", xserver_driver)
            self.append_debconf(configspace + "/config/device/use_fbdev", use_fbdev)
            self.append_debconf(configspace + "/config/device/bus_id", bus_id)
        else:
            # XXX: handle xserver-xsun
            pass

        # now set the questions that will cause the changes to take effect in
        # the real config files
        # XXX: This style of configuration file management has been nuked as of
        # 4.2.1-10, but the xfree86v3 packages haven't been updated yet.  When
        # it has, its X server packages should delcare a conflict with
        # xserver-common (<< 4.2.1-10), and the following block of code can be
        # deleted.  Don't forget the occurrence of
        # shared/clobber_x-server_symlink in dexlet_attributes.
        if configspace == "shared/xfree86v3":
            for template in [ "shared/clobber_x-server_symlink",
                              configspace + "/manage_config_with_debconf",
                              configspace + "/move_existing_nondebconf_config" ]:
                self.append_debconf(template, "true")

    def report_debconf(self):
        return self.debconf_data

configlet.register_configlet(Dexlet, dexlet_attributes)

# vim:ai:et:tw=0:sts=4:sw=4:
