# This configuration file gives defaults for the scripts in
# the devscripts package, as documented in the individual manpages.
# Variables defined here may be overridden by a per-user ~/.devscripts
# configuration file, which has exactly the same syntax as this file.
# 
# This file is sourced by /bin/bash, and should only contain
# comment lines (beginning with a '#'), and lines of the form
# VARIABLE=value
# The value must be quoted if there are spaces in it.
# Variables corresponding to switches (on/off; yes/no) must take
# one of the values 'yes' or 'no'.
# The variable names are all of the form PROGNAME_VARNAME,
# or DEVSCRIPTS_VARNAME if they are more generally applicable.
# 
# As new variables are introduced into the devscripts program, their
# descriptions and default values will be appended as comments
# to this file.

# Variables recognised as of devscripts version 2.8.14:

##### Package-wide variables
# 
# Lists of which scripts are affected by these package-wide variables
# can be found in the devscripts.conf(5) manpage.
# 
# 
# Directory Name Checking
# 
# Several programs check the directory name and refuse to function if
# it does not match the name of the package being worked on.  (The
# details are described in the individual manpages.)
# These two variables control this behaviour, corresponding to the
# --check-dirname-level and --check-dirname-regex command line options.
# The possible values of DEVSCRIPTS_CHECK_DIRNAME_LEVEL are:
#   0    never check the directory name
#   1    check the directory name only if the program has changed directory
#   2    always check the directory name
# The variable DEVSCRIPTS_DIRNAME_REGEXP is a Perl regex which
# defines what is considered a valid directory name for the source
# package PACKAGE; if it includes a '/', then it must match the full
# directory path, otherwise it must match the full directory name.
# 
# The default settings are:
# DEVSCRIPTS_CHECK_DIRNAME_LEVEL=1
# DEVSCRIPTS_CHECK_DIRNAME_REGEX='PACKAGE(-.*)?'

##### bts
# 
# Default bts show/bugs to run in offline mode?
# BTS_OFFLINE=no
# 
# Cache all visited bug reports once a cache has been established
# for the first time?
# BTS_CACHE=yes
# 
# How much to mirror when caching?  The minimal amount (min), the mbox
# version as well (mbox) or the whole works (full)?
# BTS_CACHE_MODE=min
# 
# Always refresh the cache, even if nothing's changed?
# BTS_FORCE_REFRESH=no
# 
# How do we read an mbox?  This will be split on whitespace, then
# %s is replaced by the mbox name and %% by a single %.
# BTS_MAIL_READER='mutt -f %s'

##### checkbashisms
# 
# No variables currently

##### cvs-debc
# 
# No variables currently

##### cvs-debi
# 
# No variables currently

##### cvs-debuild
# 
# No variables currently

##### debc
# 
# No variables currently

##### debchange/dch
# 
# Preserve the source tree dirname if the upstream version changes?
# DEBCHANGE_PRESERVE=no
# 
# Query the BTS when --closes is being used?
# DEBCHANGE_QUERY_BTS=yes

##### debclean
# 
# Remove .deb, .changes, .dsc and .upload files?
# DEBCLEAN_CLEANDEBS=no

##### debdiff
# 
# Show directory names which appear in the filelist?
# DEBDIFF_DIRS=no
# 
# Compare control files of two .debs?
# DEBDIFF_CONTROL=yes
# 
# Show files which have moved between .debs?
# DEBDIFF_SHOW_MOVED=no
# 
# Option to pass to wdiff
# DEBDIFF_WDIFF_OPT=

##### debi
# 
# No variables currently

##### debpkg
# 
# No variables currently

##### debrelease
# 
# This specifies which uploader program to use.  As of devscripts 2.8.14
# the recognised values are "dupload" (default) and "dput".  Check the
# debrelease(1) manpage for any recent changes to this variable
# DEBRELEASE_UPLOADER=dupload

##### debrsign
# 
# No variables currently

##### debsign
# 
# Which signing program to use?  gpg and pgp are the usual values; the
# default is determined as described in the manpage.
# Corresponds to -p option
# DEBSIGN_PROGRAM=
# 
# How the signing program works; must be either gpg or pgp as of
# devscripts version 2.8.14.  The default is described in the
# manpage.  Corresponds to -sgpg and -spgp.
# DEBSIGN_SIGNLIKE=
# 
# Maintainer name (only used to determine GPG keyid; -m option)
# DEBSIGN_MAINT=
# 
# GPG keyid to use (-k option)
# DEBSIGN_KEYID=

##### debuild
# 
# Do we preserve the whole environment except for PATH?
# DEBUILD_PRESERVE_ENV=no
# 
# Are there any environment variables we should preserve?  This should
# be a comma-separated list.
# DEBUILD_PRESERVE_ENVVARS=""
# 
# How to set a preserved environment variable, in this case to set
# FOO=bar.
# DEBUILD_SET_ENVVAR_FOO=bar
# 
# Corresponds to the dpkg-buildpackage -r option.
# DEBUILD_ROOTCMD=fakeroot
# 
# Extra options given to dpkg-buildpackage before any command-line
# options specified.  Single options containing spaces should be
# quoted, for example "-m'Julian Gilbey <jdg@debian.org>' -us -uc"
# If this contains a -r, -d or -D option, this will also be recognised
# when running debuild binary|binary-arch|...
# DEBUILD_DPKG_BUILDPACKAGE_OPTS=""
# 
# Do we run lintian at the end of a full run?
# DEBUILD_LINTIAN=yes
# 
# Do we run linda at the end of a full run?
# DEBUILD_LINDA=no
# 
# Extra options given to lintian before any command-line options
# specified.
# DEBUILD_LINTIAN_OPTS=""
# 
# Extra options given to linda before any command-line options
# specified.
# DEBUILD_LINDA_OPTS=""

##### dpkg-depcheck
# 
# Extra options given to dpkg-depcheck before any command-line
# options specified.  For example: "-b --features=-catch-alternatives"
# DPKG_DEPCHECK_OPTIONS=""

##### dpkg-genbuilddeps
# 
# No variables currently

##### dscverify
# 
# A colon separated list of extra keyrings to read.
# DSCVERIFY_KEYRINGS=""

##### grep-excuses
# 
# This specifies a default maintainer name or email to hunt for
# GREP_EXCUSES_MAINTAINER=""
# 
# Is this running on ftp-master.debian.org?  If so, we use the local
# excuses file
# GREP_EXCUSES_FTP_MASTER=no

##### mergechanges
# 
# No variables currently

##### plotchangelog
# 
# Command line options to use (space separated).  None of the options
# should contain spaces.  Use the PLOTCHANGELOG_GNUPLOT variable for
# the --gnuplot command line option.
# PLOTCHANGELOG_OPTIONS=""
# 
# Here we can give gnuplot options.  Any command line --gnuplot
# commands will be appended to these.
# PLOTCHANGELOG_GNUPLOT=""

##### uscan
# 
# Should we download newer upstream files we come across?
# USCAN_DOWNLOAD=yes
# 
# Should we use FTP PASV mode for ftp:// links?  'default' means let
# Net::FTP(3) make the choice (primarily based on the FTP_PASSIVE
# environment variable); 'yes' and 'no' override the default
# USCAN_PASV=default
# 
# Should we create a symlink from the downloaded tar.gz file to
# pkg_version.orig.tar.gz, rename it like this or do nothing?
# Options are 'symlink'/'yes', 'rename' or 'no'
# USCAN_SYMLINK=yes
# 
# Should we use DEHS style output (XML format)?
# USCAN_DEHS_OUTPUT=no
# 
# Should we give verbose output?
# USCAN_VERBOSE=no

##### uupdate
# 
# Should we retain the pristine upstream source wherever possible?
# UUPDATE_PRISTINE=yes
# 
# Should we symlink the .orig.tar.gz file to its new name or
# copy it instead?  yes=symlink, no=copy
# UUPDATE_SYMLINK_ORIG=yes
# 
# Corresonds to the dpkg-buildpackage -r option and debuild
# DEBUILD_ROOTCMD option.  Normally, this can be left empty, as then
# the debuild setting will be used.
# UUPDATE_ROOTCMD=''

