# Configure paths for ucd-snmp, GPLv2
# Markus Fischer <mfischer@josefine.ben.tuwien.ac.at>,  22.9.1999
# URL : http://josefine.ben.tuwien.ac.at/~mfischer/m4/ucd-snmp.m4
# Last Modified : Thu Sep 23 14:24:15 CEST 1999
#
# written from scratch with a few pieces from glib.m4

dnl AM_PATH_UCDSNMP([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND ]]])
dnl Test for ucd-snmp and define UCDSNMP_CFLAGS, UCDSNMP_LDFLAGS and UCDSNMP_LIBS
dnl

AC_DEFUN(AM_PATH_UCDSNMP,
[
AC_ARG_WITH(ucdsnmp-prefix, [--with-ucdsnmp-prefix=PFX Prefix where ucd-snmp is installed],
            ucdsnmp_prefix="$withval",
            ucdsnmp_prefix="")

AC_ARG_WITH(ucdsnmp-include, [--with-ucdsnmp-include=DIR Directory pointing to ucd-snmp include files],
            ucdsnmp_include="$withval",
            ucdsnmp_include="")

AC_ARG_WITH(ucdsnmp-lib,
[  --with-ucdsnmp-lib=LIB  Directory pointing to ucd-snmp library
                          (Note: -include and -lib do override
                           paths found with -prefix)
],
            ucdsnmp_lib="$withval",
            ucdsnmp_lib="")

    AC_MSG_CHECKING([for ucd-snmp ifelse([$1], , ,[>= v$1])])
    UCDSNMP_LDFLAGS=""
    UCDSNMP_CFLAGS=""
    UCDSNMP_LIBS="-lsnmp"
    ucdsnmp_fail=""

    dnl test --with-ucdsnmp-prefix
    if test "x$ucdsnmp_prefix" != "x" ; then
        if test -d "$ucdsnmp_prefix" ; then
            if test -d "$ucdsnmp_prefix/lib" ; then
                UCDSNMP_LDFLAGS="-L$ucdsnmp_prefix/lib"
            fi
            if test -d "$ucdsnmp_prefix/include" ; then
                UCDSNMP_CFLAGS="-I$ucdsnmp_prefix/include"
            fi
        fi
    fi

    dnl test --with-ucdsnmp-include
    if test "x$ucdsnmp_include" != "x" ; then
        if test -d "$ucdsnmp_include/include" ; then
            UCDSNMP_CFLAGS="-I$ucdsnmp_include/include"
        elif test -d "$ucdsnmp_include" ; then
            UCDSNMP_CFLAGS="-I$ucdsnmp_include"
        fi
    fi

    dnl test --with-ucdsnmp-lib
    if test "x$ucdsnmp_lib" != "x" ; then
        if test -d "$ucdsnmp_lib/lib" ; then
            UCDSNMP_LDFLAGS="-L$ucdsnmp_lib/lib"
        elif test -d "$ucdsnmp_lib" ; then
            UCDSNMP_LDFLAGS="-L$ucdsnmp_lib"
        fi
    fi

    ac_save_CFLAGS="$CFLAGS"
    ac_save_LDFLAGS="$LDFLAGS"
    ac_save_LIBS="$LIBS"
    CFLAGS="$CFLAGS $UCDSNMP_CFLAGS"
    LDFLAGS="$LDFLAGS $UCDSNMP_LDFLAGS"
    LIBS="$LIBS $UCDSNMP_LIBS"
    dnl if no minimum version is given, just try to compile
    dnl else try to compile AND run
    if test "x$1" == "x" ; then
        AC_TRY_COMPILE([
            #include <stdarg.h>
            #include <stdio.h>
            #include <string.h>
            #include <sys/types.h>
            #include <ucd-snmp/asn1.h>
            #include <ucd-snmp/snmp_api.h>
            #include <ucd-snmp/mib.h>
            #include <ucd-snmp/snmp.h>
        ],[
            struct snmp_session s;
            bzero( &s, sizeof( struct snmp_session));
            snmp_open(&s);
        ],[AC_MSG_RESULT(yes)
           CFLAGS="$ac_save_CFLAGS"
           LDFLAGS="$ac_save_LDFLAGS"
           LIBS="$ac_save_LIBS"
           ifelse([$2], ,:,[$2])
        ],[
          ucdsnmp_fail="yes"
        ])
    else
        ucdsnmp_min_version=$1
        AC_TRY_RUN([
            #include <stdarg.h>
            #include <stdio.h>
            #include <string.h>

            #include <sys/types.h>
            #include <ucd-snmp/asn1.h>
            #include <ucd-snmp/snmp_api.h>
            #include <ucd-snmp/mib.h>
            #include <ucd-snmp/snmp.h>
            #include <ucd-snmp/version.h>

            int main() {
                int major, minor, micro;
                int ucd_major, ucd_minor, ucd_micro;
                char *version1, *version2;
                struct snmp_session s;

                bzero(&s, sizeof( struct snmp_session));
                snmp_open(&s);

                version1 = strdup( "$ucdsnmp_min_version");
                if( sscanf( version1, "%d.%d.%d", &major, &minor, &micro) != 3) {
                  printf( "%s, bad supplied version string\n", "$ucdsnmp_min_version");
                  exit(1);
                }

                version2 = strdup( VersionInfo);
                if( sscanf( version2, "%d.%d.%d", &ucd_major, &ucd_minor, &ucd_micro) != 3) {
                  printf( "%s, bad ucd-snmp version string\n", VersionInfo);
                  exit(1);
                }

                if((ucd_major > major) ||
                  ((ucd_major == major) && (ucd_minor > minor)) ||
                  ((ucd_major == major) && (ucd_minor == minor) && (ucd_micro >= micro))) {
                  return 0;
                } else {
                  printf("\n***\n*** An old version of ucd-snmp (%d.%d.%d) was found.\n",
                         ucd_major, ucd_minor, ucd_micro);
                  printf("*** You need a version of ucd-snmp newer than %d.%d.%d. The latest version of\n",
                         major, minor, micro);
                  printf("*** ucd-snmp is available from ftp://ucd-snmp.ucdavis.edu/ .\n***\n");
                }
                return 1;
            }
        ],[AC_MSG_RESULT(yes)
           CFLAGS="$ac_save_CFLAGS"
           LDFLAGS="$ac_save_LDFLAGS"
           LIBS="$ac_save_LIBS"
           ifelse([$2], ,:,[$2])
        ],[
          ucdsnmp_fail="yes"
        ])

    fi

    if test "x$ucdsnmp_fail" != "x" ; then
            dnl AC_MSG_RESULT(no)
            echo
            echo "***"
            echo "*** ucd-snmp test source had problems, check your config.log ."
            echo "*** Also try one of the following switches :"
            echo "***   --with-ucdsnmp-prefix=PFX"
            echo "***   --with-ucdsnmp-include=DIR"
            echo "***   --with-ucdsnmp-lib=DIR"
            echo "***"
            CFLAGS="$ac_save_CFLAGS"
            LDFLAGS="$ac_save_LDFLAGS"
            LIBS="$ac_save_LIBS"
            ifelse([$3], ,:,[$3])
    fi

    CFLAGS="$ac_save_CFLAGS"
    LDFLAGS="$ac_save_LDFLAGS"
    LIBS="$ac_save_LIBS"
    AC_SUBST(UCDSNMP_LDFLAGS)
    AC_SUBST(UCDSNMP_CFLAGS)
    AC_SUBST(UCDSNMP_LIBS)
])
