package maslab.examples;

import maslab.camera.*;
import maslab.telemetry.channel.*;
import maslab.telemetry.*;
import maslab.util.*;

import java.awt.*;
import java.awt.image.*;
import java.io.*;

/** Demonstrates how to use the maslab.telemetry package to view data
 * from your robot remotely.  Run this demo and view the results with
 * BotClient.
 **/
public class TeleDemo
{
    Logger log = new Logger(this);

    TextChannel   myTextChannel = new TextChannel("Angle");
    TextChannel   commandChannel = new TextChannel("Command Interface");
    VectorChannel v = new VectorChannel("Map");
    ScopeChannel  myScopeChannel = new ScopeChannel("Motor Current");
    ImageChannel  myImageChannel = new ImageChannel("Camera",false,1);

    // The logger channel registers a LoggerPublisher to display Log
    // messages on botclient.
    JugLoggerPublisher logPublisher = new JugLoggerPublisher("LogMessage");

    Camera cam;

    public static void main(String[] args)
    {
	TeleDemo app = new TeleDemo();

	app.run();
    }

    public TeleDemo()
    {
	//Register to receive commands from botclient
	Channel.addCommandListener(new ExampleListener());

	try {
	    cam = new Camera();
	} catch (Exception ex) {
	    System.out.println("Couldn't connect to camera: "+ex);
	    return;
	}

	logPublisher.setLevel("TeleDemo", Logger.VERBOSE);
	logPublisher.setGlobalLevel(Logger.WARN);
     }

    public void run()
    {

	double ang = 0;
	v.setColor(Color.RED);
	v.drawLine(-100,-100,0,0);
	v.drawLine(0,0,100,0);
	v.drawLine(100,0,100,100);
	v.drawLine(100,100,150,150);
	v.drawLine(150,150,150,200);
	v.drawLine(150,200,0,200);
	v.drawLine(0,200,-200,500);
	v.setColor(Color.YELLOW);
	v.drawCircle(50,50,20);
	v.drawLine(50,50,70,05);

	while(true)
	    {
		BufferedImage b = cam.capture();

		b.setRGB(0,0,Color.red.getRGB());

		myImageChannel.publish(b);
		ang += 0.1;
		myScopeChannel.publish(Math.random()*5 + 15*Math.sin(ang));
		myTextChannel.publish("Angle: " + ang + "\n");

		log.output("Here's a log message");

		try{
		    Thread.sleep(100);
		} catch(InterruptedException ex) {}
		
	    }
    }

    /** This is a simple listener that prints out whatever command is
     * sent from the BotClient.  **/
    class ExampleListener implements JugMessageListener
    {
	public void messageReceived(String channelname, byte[] data)
	{
	    String s = new String(data);
	    String[] tokens = s.split(" ");

	    commandChannel.publish("\n");

	    if (tokens[0].equals("help"))
		{
		    commandChannel.publish("Help: \n");
		    commandChannel.publish("  camera <width> <height>  -- change camera resolution\n");
		    return;
		}

	    if (tokens[0].equals("camera"))
		{
		    try {
			int width = Integer.parseInt(tokens[1]);
			int height = Integer.parseInt(tokens[2]);
			cam.setCaptureSettings(width, height, 10);
			commandChannel.publish("Set width to "+width+"x"+height+"\n");
		    } catch (Exception ex) {
			commandChannel.publish("Oops: "+ex);
		    }
		    return;
		}

	    commandChannel.publish("Unknown command "+s+"\n");
	}
    }
}
