package maslab.geom;

import java.io.*;

public class GLineSegment2D implements Serializable
{
    public GLine2D line;
    public GPoint2D p1;
    public GPoint2D p2;

    static final long serialVersionUID=1001;

    public GLineSegment2D(GPoint2D p1, GPoint2D p2)
    {
	this.p1=p1;
	this.p2=p2;
	this.line=new GLine2D(p1,p2);
    }

    /** Returns the point where this segment intersects this line, or null
     * if they do not intersect. 
     **/
    public GPoint2D intersectionWith(GLine2D l)
    {
	GPoint2D p=line.intersectionWith(l);
	if (p==null)
	    return null; //parallel!

	double a,b,c;
	a=line.getLineCoordinate(p1);
	b=line.getLineCoordinate(p2);
	c=line.getLineCoordinate(p);

	// b must be between a and c.
	if ((a<b && b<c) || (c<b && b<a))
	    return p;

	return null;
    }

    public GPoint2D intersectionWith(GLineSegment2D seg)
    {
	GPoint2D p=line.intersectionWith(seg.line);
	if (p==null)
	    return null; //parallel!

	double a,b,c;
	a=line.getLineCoordinate(p1);
	b=line.getLineCoordinate(p2);
	c=line.getLineCoordinate(p);

	// does intersection lie on first line?
	if ((c<a && c<b) || (c>a && c>b))
	    return null;

	a=seg.line.getLineCoordinate(seg.p1);
	b=seg.line.getLineCoordinate(seg.p2);
	c=seg.line.getLineCoordinate(p);

	// does intersection lie on first line?
	if ((c<a && c<b) || (c>a && c>b))
	    return null;

	return p;
    }

    public double distanceTo(GPoint2D p)
    {
	GPoint2D pclosest=line.pointOnLineClosestTo(p);

	double a,b,c;
	a=line.getLineCoordinate(p1);
	b=line.getLineCoordinate(p2);
	c=line.getLineCoordinate(pclosest);

	if (c<a && c<b)
	    {
		return line.getPointOfCoordinate(Math.min(a,b)).distanceTo(p);
	    }
	if (c>a && c>b)
	    {
		return line.getPointOfCoordinate(Math.max(a,b)).distanceTo(p);
	    }

	return pclosest.distanceTo(p);
    }

    public GLineSegment2D transform(double theta, double dx, double dy)
    {
	return new GLineSegment2D(p1.transform(theta,dx,dy),p2.transform(theta,dx,dy));
    }
}
