package maslab.orcspy;

import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;

public class SmallButton extends JComponent
{
    public static final long serialVersionUID=1001;

    int textwidth=20,textheight=10;

    int marginx=2,marginy=1;
    String label;

    boolean pressed=false;

    ArrayList<ActionListener> actionListeners=new ArrayList<ActionListener>();

    boolean firstdraw=true;

    /** Don't specify actual values; both the goal and actual will be copied
	from the first actual notification. **/
    public SmallButton(String label)
    {
	this.label=label;

	addMouseListener(new MyMouseListener());
    }

    public void addActionListener(ActionListener al)
    {
	actionListeners.add(al);
    }

    public Dimension getMinimumSize()
    {
	return new Dimension(textwidth+marginx*2+10, textheight+marginy*2+3);
    }

    public Dimension getPreferredSize()
    {
	return getMinimumSize();
    }

    public synchronized void paint(Graphics gin)
    {
	Graphics2D g=(Graphics2D) gin;
	g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

	int height=getHeight();
	int width=getWidth();

	g.translate(marginx, marginy);
	height-=marginy*2;
	width-=marginx*2;
	int cy=height/2;
	int cx=width/2;

	Color bgcolor=getParent().getBackground();
	g.setColor(bgcolor);
	g.fillRect(0,0,width,height);

	/////// the bar
	RoundRectangle2D.Double barr=new RoundRectangle2D.Double(0, cy-height/2,
								 width, height,
								 height, height);
	
	g.setColor( pressed ? Color.gray : Color.white);
	g.fill(barr);
	g.setColor(Color.black);
	g.draw(barr);

	Font f=new Font("Helvetica", Font.PLAIN, 9);
	g.setFont(f);
	FontMetrics fm=g.getFontMetrics();

	textwidth=fm.stringWidth(label);
	textheight=fm.getMaxAscent()+fm.getMaxDescent();

	g.drawString(label, cx-textwidth/2, cy+fm.getMaxAscent()/2);

	if (firstdraw)
	    {
		firstdraw=false;
		invalidate();
		getParent().validate();
		repaint();
	    }
    }
    
    void handleClick()
    {
	ActionEvent ae=new ActionEvent(this, ActionEvent.ACTION_FIRST,"CLICK");

	for (ActionListener al :actionListeners)
	    al.actionPerformed(ae);
	repaint();
    }

    class MyMouseListener extends MouseAdapter
    {
	public void mousePressed(MouseEvent e)
	{
	    pressed=true;
	    repaint();
	    handleClick();

	}
	public void mouseReleased(MouseEvent e)
	{
	    pressed=false;
	    repaint();
	}
    }
}
