package maslab.telemetry.botclient;

import maslab.util.*;
import maslab.telemetry.*;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.event.*;
import java.io.*;
import javax.swing.text.*;
import java.util.*;
import java.net.*;

/** The control panel window for BotClient.**/
public class ControlPanel extends JInternalFrame implements ActionListener,StatusListener
{
    BotClient bc;

    YellowTextField ipTextField;
    JTextField botCommandField;
    JList list;
    JLabel status;
    JLabel botCommandLabel;
    DefaultListModel listModel;
    PopupListener pl;

    static final long serialVersionUID = 1001;

    static Logger log = new Logger("ControlPanel");

    public ControlPanel(BotClient bc)
    {

	setSize(220,250);
	setTitle("Control Panel");
	setBackground(Color.lightGray);
	setIconifiable(true);
	setResizable(true);

	GridBagLayout gb = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();
	getContentPane().setLayout(gb);

	JLabel label = new JLabel("Available Channels");

	c.gridwidth = 2;
	c.gridheight = 1;
	c.gridx = 0;
	c.gridy = 0;
	c.weightx = 30;
	c.weighty = 0;
	c.fill = GridBagConstraints.NONE;
	gb.setConstraints(label,c);
	getContentPane().add(label);


	listModel = new DefaultListModel();
	list = new JList(listModel);
	JScrollPane scrollPane = new JScrollPane(list);

	c.gridwidth = 2;
	c.gridheight = 1;
	c.gridx = 0;
	c.gridy = 1;
	c.weightx = 70;
	c.weighty = 70;
	c.fill = GridBagConstraints.BOTH;
	gb.setConstraints(scrollPane,c);
	getContentPane().add(scrollPane);


	label = new JLabel("Robot IP: ");

	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 0;
	c.gridy = 3;
	c.weightx = 0;
	c.weighty = 0;
	c.anchor = GridBagConstraints.WEST;
	c.fill = GridBagConstraints.NONE;
	gb.setConstraints(label,c);
	getContentPane().add(label);


	ipTextField = new YellowTextField("127.0.0.1");

	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 1;
	c.gridy = 3;
	c.weightx = 30;
	c.weighty = 0;
	c.anchor = GridBagConstraints.WEST;
	c.fill = GridBagConstraints.HORIZONTAL;
	gb.setConstraints(ipTextField,c);
	getContentPane().add(ipTextField);


	botCommandLabel = new JLabel("Send Command: ");
	botCommandLabel.setEnabled(false);

	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 0;
	c.gridy = 4;
	c.weightx = 0;
	c.weighty = 0;
	c.anchor = GridBagConstraints.WEST;
	c.fill = GridBagConstraints.NONE;
	gb.setConstraints(botCommandLabel,c);
	getContentPane().add(botCommandLabel);


	botCommandField = new JTextField();
	botCommandField.setEnabled(false);

	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 1;
	c.gridy = 4;
	c.weightx = 0;
	c.weighty = 0;
	c.anchor = GridBagConstraints.WEST;
	c.fill = GridBagConstraints.HORIZONTAL;
	gb.setConstraints(botCommandField,c);
	getContentPane().add(botCommandField);



	label = new JLabel("Status: ");

	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 0;
	c.gridy = 5;
	c.weightx = 0;
	c.weighty = 0;
	c.anchor = GridBagConstraints.WEST;
	c.fill = GridBagConstraints.NONE;
	gb.setConstraints(label,c);
	getContentPane().add(label);


	status = new JLabel("Disconnected");
	status.setForeground(Color.red);

	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 1;
	c.gridy = 5;
	c.weightx = 0;
	c.weighty = 0;
	c.anchor = GridBagConstraints.WEST;
	c.fill = GridBagConstraints.NONE;
	gb.setConstraints(status,c);
	getContentPane().add(status);
	

	ipTextField.addActionListener(this);
	botCommandField.addActionListener(this);

	pl = new PopupListener();
	list.addMouseListener(pl);


	setVisible(true);

	this.bc = bc;
    }


    public void actionPerformed(ActionEvent e)
    {
	Object o = e.getSource();


	if (o == ipTextField)
	    {
		ipTextField.setBackground(Color.white);
		list.grabFocus();
		try{
		    InetAddress ip = InetAddress.getByName(e.getActionCommand());
		    bc.setIP(ip);
		}
		catch(UnknownHostException uhe){
		    JOptionPane.showMessageDialog(null,"Unknown host: " + e.getActionCommand());
		}
		return;
	    }


	if (o == botCommandField)
	    {
		bc.userCommand(e.getActionCommand());
		botCommandField.setText("");
	    }
       	
    }


    public void statusChanged(StatusEvent e)
    {
	log.vverbose("Status Changed: " + e.name + " = " + e.booleanValue);
	String name = e.name;
	if (name.equals("connected"))
	    {
		if (e.booleanValue)
		    {
			status.setText("Connected");
			status.setForeground(Color.green);
			botCommandLabel.setEnabled(true);
			botCommandField.setEnabled(true);
			refreshChannelList();
		    }
		else
		    {
			status.setText("Disconnected");
			status.setForeground(Color.red);
			botCommandLabel.setEnabled(false);
			botCommandField.setEnabled(false);

			//Clear list
			listModel = new DefaultListModel();
			list.setModel(listModel);
		    }
	    }

	if (name.equals("newchannel"))
	    refreshChannelList();
    }

    void refreshChannelList()
    {
	//Clear list
	listModel = new DefaultListModel();
	list.setModel(listModel);

	ArrayList channels = bc.getChannels();

	for (int i=0; i<channels.size(); i++)
	    {
		String[] nametype = ((String)channels.get(i)).split("\\$");
		
		if (!nametype[1].equals("hidden"))
		    listModel.addElement(new ChannelListItem(nametype[0],nametype[1]));
	    }
	list.repaint();
    }

    class YellowTextField extends JTextField implements DocumentListener
    {
	static final long serialVersionUID = 1001;

	public YellowTextField(String s)
	{
	    super(s);
	    getDocument().addDocumentListener(this);

	}
	
	public void changedUpdate(DocumentEvent e)
	{
	    setBackground(Color.yellow);	
	}
	public void insertUpdate(DocumentEvent e)
	{
	    changedUpdate(e);
	};
	public void removeUpdate(DocumentEvent e)
	{
	    changedUpdate(e);
	};
    }

    class PopupListener extends MouseAdapter implements ActionListener
    {
	ChannelListItem item;
	String def;
	
	//Doubleclick opens defaults plugin
	public void mouseClicked(MouseEvent e)
	{
	    if (e.getClickCount() != 2 || !SwingUtilities.isLeftMouseButton(e))
		return;

	    int index = list.locationToIndex(e.getPoint());
	    if (index == -1)
		return;
	    
	    item = (ChannelListItem)listModel.getElementAt(index);


	    log.verbose("Instantiating default handler for type " + item.type);
	    bc.newDefaultHandler(item.name,item.type);
	    
	}

	public void mouseReleased(MouseEvent e)
	{
	    //Right click - bring up popup menu
	    if (SwingUtilities.isRightMouseButton(e))
		{
		    int index = list.locationToIndex(e.getPoint());
		    if (index != -1)
			{
			    item = (ChannelListItem)listModel.getElementAt(index);
			    item.pop.show(list,e.getX(),e.getY());
			    list.setSelectedIndex(index);
			}
		}
	}

	
	
	public void actionPerformed(ActionEvent e)
	{
	    if (item == null)
		return;

	    String pluginName = e.getActionCommand();	 	
	    bc.newHandler(item.name,item.type,pluginName);
	}




    }

    class ChannelListItem
    {
	public String name;
	public String type;
	public JPopupMenu pop;

	public ChannelListItem(String name, String type)
	{
	    this.name = name;
	    this.type = type;

	    pop = new JPopupMenu();
	    String[] plugins = bc.getPlugins(type);
	    if (plugins != null)
		{
		    for (int i=0; i<plugins.length; i++)
			{
			    JMenuItem item = new JMenuItem(PluginController.shortName(plugins[i]));
			    pop.add(item);
			    item.addActionListener(pl);
			}
		
		}
	}


	public String toString()
	{
	    return name + " - " + type;
	}

    }
    

    
}


