package maslab.test;
 
import java.net.*;
import java.io.*;
import java.awt.image.*;
import java.awt.*;
import java.awt.color.ColorSpace;
import java.util.*;
import java.util.concurrent.*;

import maslab.util.*;
import maslab.orc.*;

public class I2CTest
{
    public static void main(String[] args)
    {
	Orc orc;

	try {
	    orc=new Orc();
	} catch (Exception ex) {
	    return;
	}

	LoggerPublisher logPublisher=new LoggerPublisher();
	logPublisher.setLevel("Orc", Logger.WARN);

	orc.lcdConsoleHome();

	orc.lcdConsoleWrite("hello, world.*");
	orc.lcdFill(0xff,0xff);

	orc.lcdDrawMode(Orc.DrawMode.ERASE);
	orc.lcdDrawLine(0,0,64,63);

	// My test I2C device returns the string "Edwin Olson", if the
	// value 0xED is written.  Otherwise, it will echo data
	// written to it.

	while(true)
	    {
		boolean res;
		byte[] buf = new byte[16];

		buf[0]=(byte) 0xed;
		int addr=16;

		// try the 0xED command

		res=orc.i2cWrite(addr, buf, 1);
		if (!res)
		    System.out.println("write failed");

		res=orc.i2cRead(addr, buf, 12);
		if (!res)
		    System.out.println("read failed");
		else
		    {
			for (int i=0;i<12;i++)
			    System.out.print(" "+((char) buf[i]));
			System.out.println("");
		    }

		/// try a different test
		buf[0]=12;
		buf[1]=34;
		buf[2]=56;
		res=orc.i2cWrite(addr, buf, 3);
		if (!res)
		    System.out.println("write failed");

		for (int i=0;i<10;i++)
		    buf[i]=0;

		res=orc.i2cRead(addr, buf, 3);
		if (!res)
		    System.out.println("read failed");
		else
		    {
			for (int i=0;i<3;i++)
			    System.out.print(" "+ buf[i]);
			System.out.println("");
		    }


		byte[] writebuf=new byte[] {(byte) 0xed};
		byte[] readbuf=new byte[30];

		res=orc.i2cWriteRead(addr, writebuf, 1, readbuf, 20);
		if (!res)
		    System.out.println("read failed");
		else
		    {
			for (int i=0;i<12;i++)
			    System.out.print(" "+((char) buf[i]));
			System.out.println("");
		    }
		
		try {
		    Thread.sleep(1000);
		} catch (InterruptedException ex) {
		}
	    }
    }
}
