package maslab.util;

import java.util.*;
import java.text.*;

/** Various useful functions for strings. **/
public class StringUtil
{

    /** Pad a string with characters on the left.
     * @param in The string to pad
     * @param length The desired final length of the string. 
     * @return The padded string. If the string was already length
     * bytes long, the original string is returned.
     **/
    public static String padLeft(String in, int length, char c)
    {
	int len=in.length();
	StringBuffer sb=new StringBuffer();

	for (int i=0;i<(length-len);i++)
	    sb.append(c);

	sb.append(in);

	return sb.toString();
    }

    /** Pad a string with characters on the right.
     * @param in The string to pad
     * @param length The desired final length of the string. 
     * @return The padded string. If the string was already length
     * bytes long, the original string is returned.
     **/
    public static String padRight(String in, int length, char c)
    {
	int len=in.length();
	StringBuffer sb=new StringBuffer();

	sb.append(in);

	for (int i=0;i<(length-len);i++)
	    sb.append(c);

	return sb.toString();
    }

    /**
       Encapsulates the functionality of StringTokenizer in semantics
       that look more like String.split(), a function that is only
       available in Java 1.4.
       @param in The string you want to split.
       @param delim The set of characters to use as delimiters.
       @return The split pieces of the original string.
    */
    public static String[] split(String in, String delim)
    {
	StringTokenizer st = new StringTokenizer(in,delim);
	int count = st.countTokens();
	String[] result = new String[count];
	for (int i=0; i<count; i++)
	    result[i] = st.nextToken();
	return result;
    }

    public static String formatDouble(double d, int decimalPlaces)
    {
	return String.format("%."+decimalPlaces+"f",d);
	/*	DecimalFormat format=new DecimalFormat();
	format.setMaximumFractionDigits(decimalPlaces);
	format.setMinimumFractionDigits(decimalPlaces);
	format.setGroupingSize(0);

	return format.format(d);*/
    }

    /** Parse a number of the format XXXXX(.YYYY)? **/
    public static double parseDouble(String in)
    {
	double acc=0;  // our number so far
	int decdivider=1; // 10^(digits after '.')
	boolean decimalFound=false;

	for (int i=0;i<in.length();i++)
	    {
		if (in.charAt(i)=='.')
		    {
			decimalFound=true;
			continue;
		    }

		acc*=10;
		acc+=in.charAt(i)-'0';

		if (decimalFound)
		    decdivider*=10;
	    }

	return acc/decdivider;
    }

    public static String formatHex(long l, int digits)
    {
	return String.format("%0"+digits+"x", l);
    }

    public static void main(String[] args)
    {
	System.out.println(""+StringUtil.formatDouble(3.1415926, 4));
    }
}
