package maslab.vis;

import java.awt.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.awt.image.*;

/** Displays information overlaid on the plot. For example, the time.**/
public class VisCaption extends VisObject
{
    public static final int TOPLEFT=1, TOPRIGHT=2, BOTTOMLEFT=3, BOTTOMRIGHT=4;

    public int location=TOPRIGHT;

    public double size=18; // in pixels

    public String label;
    public Color color=Color.white;

    int padding=4;

    int swidthp=0; // the width of the labels in pixels

    public VisCaption(Color color, int location, String label)
    {
	this.location=location;
	this.color=color;

	set(label);

	coordinateSpace=SCREENSPACE;
    }

    public void set(String label)
    {
	this.label=label;
    }

    public void paint(VisCanvas vc, Graphics2D g, BufferedImage bi)
    {
	int leading=2;
	if (label==null || label.length()==0)
	    return;

	g.setColor(color);

	String lines[]=label.split("\n");
	int yoffset[]=new int[lines.length];

	Font f=new Font("Helvetica",Font.PLAIN, (int) size);
	g.setFont(f);
	FontRenderContext frc=g.getFontRenderContext();
	int swidth=0,sheight=0;

	for (int i=0;i<lines.length;i++)
	    {
		if (lines[i]==null || lines[i].length()==0)
		    lines[i]=" ";

		TextLayout layout=new TextLayout(lines[i], f, frc);
		Rectangle2D bounds=layout.getBounds();
		swidth=Math.max(swidth,(int) bounds.getWidth());
		sheight+=(int) bounds.getHeight()+leading;
		yoffset[i]=sheight;
	    }


	int width=bi.getWidth();
	int height=bi.getHeight();

	int x,y;
	// cursor is at lower left of text position.
	switch (location)
	    {
	    case TOPLEFT:
		x=padding;
		y=padding;
		break;
	    case TOPRIGHT:
		x=width-swidth-padding;
		y=padding;
		break;
	    case BOTTOMLEFT:
		x=padding;
		y=height-padding-sheight;
		break;
	    default:
	    case BOTTOMRIGHT:
		x=width-swidth-padding;
		y=height-padding-sheight; //-sheight;
		break;
	    }

	for (int i=0;i<lines.length;i++)
	    g.drawString(lines[i], x, (int) (y+yoffset[i]));
    }

}
