package maslab.vis;

import maslab.util.*;
import maslab.geom.*;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;

/** A straight line. **/
public class VisLine extends VisObject
{
    public double size=6; // in pixels
    public Color color=Color.blue;

    public double x1,y1,x2,y2;

    /** If set to a value > 0, the line will be drawn dashed. **/
    public float dashed=0;

    public VisLine(Color c, double size, GLine2D line)
    {
	this(c, size, 0, line.getB(), 1, line.getM());
    }

    public VisLine(Color c, double size, GPoint2D p1, GPoint2D p2)
    {
	this(c, size, p1, p2, 0);
    }

    public VisLine(Color c, double size, GPoint2D p1, GPoint2D p2, float dashed)
    {
	this(c, size, p1.getX(), p1.getY(), p2.getX(), p2.getY(), dashed);
    }

    public VisLine(Color c, double size, double x1, double y1, 
		   double x2, double y2)
    {
	this(c, size, x1, y1, x2, y2, 0);
    }

    public VisLine(Color c, double size, double x1, double y1, 
		   double x2, double y2, float dashed)
    {
	this.color=c;
	this.size=size;
	this.x1=x1;
	this.y1=y1;
	this.x2=x2;
	this.y2=y2;
	this.dashed=dashed;
    }

    public void paint(VisCanvas vc, Graphics2D g, BufferedImage bi)
    {
	double scale=vc.getScale();

	double sz=size/scale;

	g.setColor(color);
	if (dashed>0)
	    g.setStroke(new BasicStroke((float) sz, BasicStroke.CAP_BUTT,
					BasicStroke.JOIN_BEVEL,0f,new float[] {dashed, dashed/2}, 0));
	else
	    g.setStroke(new BasicStroke((float) sz));

	Line2D.Double l=new Line2D.Double(x1, y1, x2, y2);

	g.draw(l);
    }
}
