package maslab.vis;

import java.awt.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.awt.image.*;
import java.io.*;
import javax.imageio.*;
import java.util.*;

import maslab.util.*;

/** Create a movie of a VisCanvas. It actually creates a whole mess of
 * still frames in a specified directory which must be converted into
 * a movie with a program such as 'convert'.  This will create a
 * directory full of png images which will need to be converted into a
 * movie with a separate application. e.g.: mencoder "mf://*.png" -mf
 * fps=10 -o output.avi -ovc lavc -lavopts
 * vcodec=mjpeg:vhq:vbitrate=2000 (or -ovc raw)
 *
 * ugh, mencoder can be so uncooperative! try this:
 *
 * mencoder mf://*.png -mf w=720:h=480:fps=29.97:type=png -ovc copy
 * -oac copy -o output.avi
 **/
public class VisMovie
{
    int width, height;
    String basepath;
    String filebase;

    String format="png";

    int nextFrameNumber=0;

    Logger log=new Logger("VisMovie");

    /** Creates a new VisMovie object.
     * @param basepath The absolute path to a directory in which to
     * write the frames. The directory will be created if necessary.
     * @param filebase The basename of the filenames. Pass in null
     * to use a unique prefix of the form "fYYYY-MM-DD-HHMM_".
     **/
    public VisMovie(String basepath, String filebase, 
		    int width, int height) throws IOException
    {
	this.width=width;
	this.height=height;
	this.basepath=basepath;

	if (filebase==null)
	    {
		Calendar calNow=Calendar.getInstance();

		Date date=new Date(System.currentTimeMillis());
		Random r=new Random();

		this.filebase=StringUtil.padLeft(""+calNow.get(Calendar.YEAR),4,'0') +
		    "-" + StringUtil.padLeft(""+
					     (1 - Calendar.JANUARY + calNow.get(Calendar.MONTH)),
					     2,'0') +
		    "-" + StringUtil.padLeft(""+ calNow.get(Calendar.DAY_OF_MONTH),2,'0') +
		    "-" + StringUtil.padLeft(""+calNow.get(Calendar.HOUR),2,'0') +
		    StringUtil.padLeft(""+calNow.get(Calendar.MINUTE),2,'0') +
		    "_";
	    }
	else
	    this.filebase=filebase;
	
	File f=new File(basepath);
	if (f!=null)
	    f.mkdirs();
    }


    public void addFrame(VisCanvas canv)
    {
	BufferedImage bi=canv.paintIntoImage(width,height);
	
	String num=StringUtil.padLeft(""+nextFrameNumber,6,'0');

	String path=basepath+"/"+filebase+num+"."+format;
	nextFrameNumber++;

	try {
	    FileOutputStream fouts=new FileOutputStream(path);
	    ImageIO.write(bi, format, fouts);
	    fouts.close();
	    log.output("Added frame "+(nextFrameNumber-1)+" ("+path+")");
	} catch (IOException ex) {
	    log.error("Couldn't write movie frame "+path,ex);
	}

    }

}
