package maslab.fig;

import java.util.*;
import java.io.*;

import maslab.util.*;


/** Used documentation from:
  * http://www.xfig.org/userman/fig-format.html
  **/
public class FigFile
{
    public String version; // e.g. #FIG3.2, the first line of the file
    public String orientation;
    public String justfication;
    public String units;
    public String papersize;
    public float magnification;
    public String multiplepage;
    public int transparentcolor;
    public int resolution;
    public int coordinatesystem;

    public ArrayList<FigObject> figObjects=new ArrayList<FigObject>();

    Logger log=new Logger("FigFile");

    class CommentFilterReader extends Reader
    {
	BufferedReader ins;
	String currentLine=null;
	int pos;

	public CommentFilterReader(Reader ins)
	{
	    this.ins=new BufferedReader(ins);
	}
	
	protected void refill() throws IOException
	{
	    if (currentLine!=null && pos<=currentLine.length())
		return;

	    while (true)
		{
		    currentLine=ins.readLine();
		    pos=0;
		    if (currentLine==null)
			return;
		    if (currentLine.charAt(0)!='#')
			return;
		}
	}

	public int read() throws IOException
	{
	    refill();

	    if (currentLine!=null && pos==currentLine.length())
		{
		    pos++;
		    return '\n';
		}

	    if (currentLine==null)
		return -1;

	    return currentLine.charAt(pos++);
	}

	public int read(char[] cbuf, int off, int len) throws IOException
	{
	    int i;

	    for (i=0;i<len;i++)
		{
		    int c=read();
		    if (c<0)
			{
			    if (i==0)
				return -1;
			    else
				return i;
			}

		    cbuf[off+i]=(char) c;
		}

	    return i;
	}

	public void close() throws IOException
	{
	    ins.close();
	}
    }

    public FigFile(File f) throws IOException
    {
	parse(f);
    }

    protected boolean parse(File f) throws IOException
    {
	BufferedReader br=new BufferedReader(new FileReader(f));
	
	version=br.readLine();
	if (version.charAt(0)!='#')
	    {
		log.error("Not a fig file");
		return false;
	    }
	
	Scanner scan=new Scanner(new CommentFilterReader(br));
	
	orientation=scan.next();
	justfication=scan.next();
	units=scan.next();
	papersize=scan.next();
	magnification=scan.nextFloat();
	multiplepage=scan.next();
	transparentcolor=scan.nextInt();
	resolution=scan.nextInt();
	coordinatesystem=scan.nextInt();

	boolean success=true;

	while (scan.hasNext())
	    {
		int type=scan.nextInt();
		
		switch (type)
		    {
		    case 2:
			FigPolyLine fo=new FigPolyLine();
			figObjects.add(fo);
			success&=fo.parse(scan);
			break;
		    case 0:
		    case 1:
		    case 3:
		    case 4:
		    case 5:
		    case 6:
		    default:
			log.warn("Unhandled type "+type);
		    }
	    }

	return success;
    }
    
    public void print()
    {
	PrintStream out=System.out;

	out.println("FigFile, version "+version);
	out.println(figObjects.size()+" objects");

	out.println("");

	for (FigObject fo : figObjects)
	    {
		fo.print(out);
	    }
    }

    public static void main(String[] args)
    {
	for (String filename: args)
	    {
		try {
		    FigFile ff=new FigFile(new File(filename));
		    ff.print();
		} catch (IOException ex) {
		    System.out.println("IOException "+ex);
		}
	    }
    }
}

