package maslab.odom;

import java.io.*;

import maslab.data.*;
import maslab.orc.*;

public class OdomData extends DataEvent
{
    public double timeStamp;
    public int leftTicks, rightTicks;

    public OdomData()
    {
    }

    public OdomData(double timeStamp, String channelName, String data)
    {
	this.timeStamp=timeStamp;
	String[] datas=data.split("\\s+");
	int[] t=new int[datas.length];
	for (int i=0;i<t.length;i++)
	    t[i]=Integer.parseInt(datas[i]);
	leftTicks=t[0];
	rightTicks=t[1];
    }

    public OdomData(double timeStamp, int leftTicks, int rightTicks)
    {
	this.timeStamp=timeStamp;
	this.leftTicks=leftTicks;
	this.rightTicks=rightTicks;
    }

    public double getTimeStamp()
    {
	return timeStamp;
    }

    public String getEventName()
    {
	return "ODOM";
    }

    public String getChannelName()
    {
	return "0";
    }

    public String getDataString()
    {
	return ""+leftTicks+" "+rightTicks;
    }

    public String toString()
    {
	return getDataString();
    }
}
