package maslab.orc;

import java.net.*;
import java.io.*;
import java.awt.image.*;
import java.awt.*;
import java.awt.color.ColorSpace;
import java.util.*;
 
import maslab.util.*;

class OrcAsyncConnection
{
    protected Socket       sock;
    protected InputStream  ins;
    protected OutputStream outs;

    protected Logger       log=new Logger(this);

    ReaderThread  reader;
    
    String host;
    int port;

    Orc orc;

    public OrcAsyncConnection(Orc orc, String host, int port) throws IOException
    {
	this.orc=orc;
	this.host=host;
	this.port=port;

	reconnect();

	reader=new ReaderThread();
	reader.start();
    }

    void reconnect()
    {
	boolean success=false;

	while (!success)
	    {
		try {
		    log.debug("Connecting");

		    sock=new Socket(host, port);
		    sock.setTcpNoDelay(true);
		    
		    ins=new BufferedInputStream(sock.getInputStream());
		    outs=sock.getOutputStream();

		    success=true;
		    log.debug("Connected");
		} catch (IOException ex) {
		    try {
			Thread.sleep(1000);
		    } catch (InterruptedException iex) {
		    }
		}
	    }
	    
	log.output("Connected");
    }

    class ReaderThread extends Thread
    {
	public ReaderThread()
	{
	    setDaemon(true);
	}

	public void run()
	{
	    boolean gotMaster=false;
	    boolean gotSlave=false;
	    boolean gotPad=false;

	    while(true)
		{
		    OrcPacket p;

		    try {
			p=OrcPacket.fromInputStream(ins);
		    } catch (IOException ex) {
			reconnect();
			continue;
		    }

		    if (p==null)
			{
			    reconnect();
			    continue;
			}

		    int flags=p.buf[2]&0x00c0;

		    if (p.buf[3]!='*')
			{
			    log.output("got funny async packet");
			    continue;
			}

		    Orc.OrcPacketHolder h;

		    if (flags==0x00)
			{
			    h=orc.masterHolder;
			    gotMaster=true;
			}
		    else if (flags==0x40)
			{
			    h=orc.slaveHolder;
			    gotSlave=true;
			}
		    else if (flags==0x80)
			{
			    h=orc.padHolder;
			    gotPad=true;
			}
		    else if (flags==0xc0)
			{
			    System.out.println("flags=0xc0, type="+p);
			    // do nothing. Why did we get this packet?
			    continue;
			}
		    else
			{
			    log.output("Unknown flags: "+flags);
			    continue;
			}

		    if ((gotMaster && gotSlave) || gotPad)
			{
			    orc.notifyUpdateListeners();
			    gotMaster=false;
			    gotSlave=false;
			    gotPad=false;
			}

		    synchronized(h)
			{
			    h.time=System.currentTimeMillis();
			    //System.out.println("stamp: "+h.time);
			    h.packet=p;

			    h.notifyAll();
			}
		}
	    
	}
    }

}
