package maslab.orc;

import java.net.*;
import java.io.*;
import java.awt.image.*;
import java.awt.*;
import java.awt.color.ColorSpace;
import java.util.*;
 
import maslab.util.*;

class OrcCommandConnection
{
    protected Socket       sock;
    protected InputStream  ins;
    protected OutputStream outs;

    protected Logger       log=new Logger(this);

    Orc orc;

    public OrcCommandConnection(Orc orc, String host, int port) throws IOException
    {
	this.orc=orc;

	//	log.output("Connecting");

	sock=new Socket(host, port);
	sock.setTcpNoDelay(true);
	
	ins=sock.getInputStream();
        outs=sock.getOutputStream();
	
	log.output("Connected");
    }

    public OrcPacket doTransaction(OrcPacket request) throws IOException
    {
	request.write(outs);
	return OrcPacket.fromInputStream(ins);
    }

}
