package maslab.orcspy;

import maslab.util.*;
import maslab.orc.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;

public class MotorPanel extends JPanel implements OrcUpdateListener
{
    public static final long serialVersionUID=1001;

    Orc orc;
    int port;

    Color      lightBlue=new Color(200, 200, 255);
    Color      lightRed=new Color(255, 100, 100);
    Color      darkRed=new Color(100, 0, 0);
    Color      yellow=new Color(255, 255, 0);

    JLabel     namelabel;

    SignalPlot  pwmplot = new SignalPlot();
    SignalPlot  currentplot = new SignalPlot();

    static final int INDENT_PX=20;

    GoalSlider  pwmslider;
    GoalSlider  slewslider;

    public MotorPanel(Orc orc, int port)
    {
	super(new GridBagLayout());

	this.orc=orc;
	this.port=port;

	Font smallfont=new Font("Dialog",Font.PLAIN, 9);
	setBackground(lightRed);

	GridBagConstraints gbc=new GridBagConstraints();
	GridBagConstraints pgbc=new GridBagConstraints();

	///////// ROW ONE
	pgbc.gridx=0; pgbc.gridy=0; pgbc.gridwidth=2; 
	pgbc.weightx=1; pgbc.weighty=1;  pgbc.fill=GridBagConstraints.BOTH;

	JPanel nameholder=new JPanel(new FlowLayout(FlowLayout.LEFT));
	namelabel=new JLabel(" Motor "+port);
	nameholder.add(namelabel);
	namelabel.setForeground(yellow);
	nameholder.setBackground(darkRed);
	namelabel.setFont(smallfont);
	add(nameholder, pgbc);

	///////// ROW TWO, including column 0 spacer
	pgbc.gridx=0; pgbc.gridy=1; pgbc.gridwidth=1; 
	pgbc.weightx=1; pgbc.weighty=1;  pgbc.fill=GridBagConstraints.BOTH;
	add(Box.createHorizontalStrut(INDENT_PX), pgbc);

	// pwm slider
	pwmslider=new GoalSlider(-255,255, true);
	pgbc.weightx=999; pgbc.weighty=1;
	pgbc.gridx=1; pgbc.gridy=1; pgbc.fill=GridBagConstraints.BOTH;
	add(pwmslider, pgbc);

	//////// ROW THREE
	pwmplot.setSize(new Dimension(200,15));
	pwmplot.setMinimumSize(new Dimension(100,15));
	pwmplot.setPreferredSize(new Dimension(200,15));

	pgbc.weightx=999; pgbc.weighty=999; 
	pgbc.gridx=1; pgbc.gridy=2; pgbc.fill=GridBagConstraints.BOTH;
	add(pwmplot, pgbc);

	//////// ROW FOUR
	slewslider=new GoalSlider(1, 255, true);
	slewslider.addGoalSliderListener(new SlewGoalSliderListener());

	pgbc.weightx=1; pgbc.weighty=1; 
	pgbc.gridx=1; pgbc.gridy=3; pgbc.fill=GridBagConstraints.BOTH;
	add(slewslider, pgbc);

	/*
	//////// ROW FIVE
	pgbc.weightx=999; pgbc.weighty=999; 
	pgbc.gridx=1; pgbc.gridy=4; pgbc.fill=GridBagConstraints.BOTH;
	add(currentplot, pgbc);
	*/

	//////// ROW FOUR
	pgbc.weightx=1; pgbc.weighty=1; 
	pgbc.gridx=1; pgbc.gridy=5; pgbc.fill=GridBagConstraints.BOTH;
	add(Box.createVerticalStrut(2), pgbc);

	////////// Other initialization
	pwmslider.addGoalSliderListener(new PWMGoalSliderListener());

	orc.addUpdateListener(this);
    }

    public void orcUpdated(Orc orc)
    {
	pwmplot.addData(Color.darkGray, 0.5f, "",
			Color.white,(float) (0.5f+orc.motorActualRead(port)/512.0f), ""+orc.motorActualRead(port),
			Color.green,(float) (0.5f+orc.motorGoalRead(port)/512.0f), ""+orc.motorGoalRead(port),
			Color.red, (float) orc.motorCurrentRead(port)/2.0f, ""+((int) (orc.motorCurrentRead(port)*1000))+" mA");
			

	pwmslider.setActualValue(orc.motorActualRead(port));

	slewslider.setActualValue(orc.motorSlewRead(port));

	currentplot.addData(Color.yellow, (float) orc.motorCurrentRead(port)/2.0f,""+
			    ((int) (orc.motorCurrentRead(port)*1000))+" mA");
    }

    class PWMGoalSliderListener implements GoalSliderListener
    {
	public void goalValueChanged(GoalSlider gs, int v)
	{
	    orc.motorWrite(port, v);
	}
    }

    public class SlewGoalSliderListener implements GoalSliderListener
    {
	public void goalValueChanged(GoalSlider gs, int goalvalue)
	{
	    orc.motorSlewWrite(port, goalvalue);
	}
    }


}
