package maslab.telemetry;

import java.io.*;

class JugPacket
{
    public int command=0;

    public String channelName=null;
    public byte[] data=null;
    public ByteArrayOutputStream bouts=null;
    public long timestamp=0;

    public static final int NOTICE_PONG=100;
    public static final int NOTICE_ADV=101;
    public static final int NOTICE_UNADV=102;
    public static final int NOTICE_MSG=103;
    public static final int NOTICE_SUBCOUNT=110; // sent to indicate the # of subscribers on a channel

    public static final int COMMAND_PING=0;
    public static final int COMMAND_ADV=1;
    public static final int COMMAND_UNADV=2;
    public static final int COMMAND_MSG=3;
    public static final int COMMAND_LIST=5;
    public static final int COMMAND_SUB=6;
    public static final int COMMAND_UNSUB=7;
    public static final int COMMAND_SUBCOUNT=10;

    public JugPacket(DataInputStream ins) throws IOException
    {
	this.command=ins.readShort();
	this.timestamp=ins.readLong();

	boolean hasChannelName=ins.readBoolean();

	if (hasChannelName)
	    {
		int cnamelen=ins.readShort();
		byte[] cnamebytes=new byte[cnamelen];
		ins.readFully(cnamebytes);
		channelName=new String(cnamebytes);
	    }


	int datalen=ins.readInt();
	if (datalen>0)
	    {
		data=new byte[datalen];
		ins.readFully(data);
	    }
    }

    public JugPacket(int cmd)
    {
	this.command=cmd;
	this.timestamp=System.currentTimeMillis();
    }

    public JugPacket(int cmd, byte[] data)
    {
	this.command=cmd;
	this.data=data;
	this.timestamp=System.currentTimeMillis();
    }

    public JugPacket(int cmd, String cname)
    {
	this.command=cmd;
	this.channelName=cname;
	this.timestamp=System.currentTimeMillis();
    }

    public JugPacket(int cmd, String cname, byte[] data)
    {
	this.command=cmd;
	this.channelName=cname;
	this.data=data;
	this.timestamp=System.currentTimeMillis();
    }

    public void write(DataOutputStream outs) throws IOException
    {
	outs.writeShort(command);
	outs.writeLong(timestamp);
	outs.writeBoolean(channelName!=null);

	if (channelName!=null)
	    {
		outs.writeShort(channelName.length());
		outs.writeBytes(channelName);
	    }

	outs.writeInt(size());

	if (data!=null)
	    outs.write(data);
	if (bouts!=null)
	    outs.write(bouts.toByteArray());

	outs.flush();
    }

    public DataInputStream getDataInputStream() throws IOException
    {
	return new DataInputStream(new ByteArrayInputStream(data));
    }

    public DataOutputStream getDataOutputStream() throws IOException
    {
	bouts=new ByteArrayOutputStream();

	return new DataOutputStream(bouts);
    }

    public int size()
    {
	int length=0;
	if (data!=null)
	    length+=data.length;
	if (bouts!=null)
	    length+=bouts.size();
	return length;
    }
}
