package maslab.vis;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;

/** An ellipse. **/
public class VisEllipse extends VisObject
{
    public double x,y,theta;
    public double xx,xy,yy;

    public double size=1; // in pixels

    public Color color=Color.yellow;
    
    public VisEllipse(Color color, double x, double y, double xx, double xy, double yy)
    {
	this.color=color;
	this.x=x;
	this.y=y;
	this.xx=xx;
	this.xy=xy;
	this.yy=yy;
    }

    public void set(double x, double y, double xx, double xy, double yy)
    {
	this.x=x;
	this.y=y;
	this.xx=xx;
	this.xy=xy;
	this.yy=yy;
    }

    public void paint(VisCanvas vc, Graphics2D g, BufferedImage bi)
    {
	double scale=vc.getScale();

	g.translate(x, y);

	// to-do: make steps dynamic.
	/*	int steps=(int) (scale*Math.sqrt(Math.abs(1/(xx*xy+xy*xy+yy*yy))));
	System.out.println("steps="+steps);
	if (steps<10)
	steps=10;
	*/
	g.setColor(color);
	g.setStroke(new BasicStroke((float) (1/scale)));

	Line2D.Double line=new Line2D.Double(0,0,0,0);

	double theta=0;
	int steps=0;

	boolean showSamplePoints=false;

	while (theta<=2*Math.PI)
	    {
		//	for (int i=0;i<steps+1;i++)
		//fast ellipse drawing		double theta=2*Math.PI*i/steps;
		double c=Math.cos(theta);
		double s=Math.sin(theta);

		double r=Math.sqrt(1/(xx*c*c+xy*c*s+yy*s*s));
		//		double drdt=-.5*r*r*r*(-2*xx*c*s+xy*(c*c-s*s)+2*yy*s*c);
		//		double curvature=drdt/r;
		//		System.out.println(curvature);

		double x=r*c;
		double y=r*s;

		line.x2=x;
		line.y2=y;

		if (theta>0)
		    g.draw(line);

		if (showSamplePoints)
		    {
			double sz=4/scale;
			g.fill(new Ellipse2D.Double(x-sz/2, y-sz/2, 
						    sz, sz)); 
		    }
	
		line.x1=line.x2;
		line.y1=line.y2;

		double dtheta=2*Math.PI/50;
		//		double dtheta=Math.min(2*Math.PI/50, Math.abs(1/(.01*curvature)));
		dtheta=Math.max(dtheta,0.0001);

		dtheta=Math.PI/50;

		theta+=dtheta;
		steps++;
	    }
	//	System.out.println("steps: "+steps);
    }

}
