package maslab.vis;

import java.awt.*;
import java.awt.image.*;

/** The abstract base class of all objects which can be drawn on a
 * VisCanvas **/
public abstract class VisObject
{
    /** Objects that are being plotted should be in world space. The
     *  paint() method deals with meters.
     **/
    public static int WORLDSPACE=1;

    /** Captions, legends, etc, might want to be in screen space
     * instead. In this case, the paint() method deals with
     * pixels. 
     **/
    public static int SCREENSPACE=2;

    /** Used by VisCanvas to determine how the coordinate space should
     * be transformed.
     **/
    public int coordinateSpace=WORLDSPACE;

    /** Overriden by each subclass to draw itself onto the provided
     * graphics context. Applications can choose to use either the Graphics2D
     * (which has the correct transform already set up) or to draw to the 
     * buffered image directly.
     */
    public abstract void paint(VisCanvas vc, Graphics2D g, BufferedImage bi);

}
