/*
 * Decompiled with CFR 0.152.
 */
package maslab.examples;

import java.awt.Color;
import java.awt.image.BufferedImage;
import maslab.telemetry.JugLoggerPublisher;
import maslab.telemetry.JugMessageListener;
import maslab.telemetry.channel.Channel;
import maslab.telemetry.channel.ImageChannel;
import maslab.telemetry.channel.ScopeChannel;
import maslab.telemetry.channel.TextChannel;
import maslab.telemetry.channel.VectorChannel;
import maslab.util.Logger;
import org.orcboard.camera.Camera;

public class TeleDemo {
    Logger log = new Logger(this);
    TextChannel myTextChannel = new TextChannel("Angle");
    TextChannel commandChannel = new TextChannel("Command Interface");
    VectorChannel v = new VectorChannel("Map");
    ScopeChannel myScopeChannel = new ScopeChannel("Motor Current");
    ImageChannel myImageChannel = new ImageChannel("Camera", false, 1);
    JugLoggerPublisher logPublisher = new JugLoggerPublisher("LogMessage");
    Camera cam;

    public static void main(String[] args) {
        TeleDemo app = new TeleDemo();
        app.run();
    }

    public TeleDemo() {
        Channel.addCommandListener(new ExampleListener());
        try {
            this.cam = Camera.makeCamera();
        }
        catch (Exception ex) {
            System.out.println("Couldn't connect to camera: " + ex);
            return;
        }
        this.logPublisher.setLevel("TeleDemo", 4);
        this.logPublisher.setGlobalLevel(2);
    }

    public void run() {
        double ang = 0.0;
        this.v.setColor(Color.RED);
        this.v.drawLine(-100, -100, 0, 0);
        this.v.drawLine(0, 0, 100, 0);
        this.v.drawLine(100, 0, 100, 100);
        this.v.drawLine(100, 100, 150, 150);
        this.v.drawLine(150, 150, 150, 200);
        this.v.drawLine(150, 200, 0, 200);
        this.v.drawLine(0, 200, -200, 500);
        this.v.setColor(Color.YELLOW);
        this.v.drawCircle(50, 50, 20);
        this.v.drawLine(50, 50, 70, 5);
        while (true) {
            BufferedImage b = this.cam.capture();
            b.setRGB(0, 0, Color.red.getRGB());
            this.myImageChannel.publish(b);
            this.myScopeChannel.publish(Math.random() * 5.0 + 15.0 * Math.sin(ang += 0.1));
            this.myTextChannel.publish("Angle: " + ang + "\n");
            this.log.output("Here's a log message");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
            }
        }
    }

    class ExampleListener
    implements JugMessageListener {
        ExampleListener() {
        }

        public void messageReceived(String channelname, byte[] data) {
            String s = new String(data);
            String[] tokens = s.split(" ");
            TeleDemo.this.commandChannel.publish("\n");
            if (tokens[0].equals("help")) {
                TeleDemo.this.commandChannel.publish("Help: \n");
                TeleDemo.this.commandChannel.publish("  camera <width> <height>  -- change camera resolution\n");
                return;
            }
            if (tokens[0].equals("camera")) {
                try {
                    int width = Integer.parseInt(tokens[1]);
                    int height = Integer.parseInt(tokens[2]);
                    TeleDemo.this.cam.setCaptureSettings(width, height, 10);
                    TeleDemo.this.commandChannel.publish("Set width to " + width + "x" + height + "\n");
                }
                catch (Exception ex) {
                    TeleDemo.this.commandChannel.publish("Oops: " + ex);
                }
                return;
            }
            TeleDemo.this.commandChannel.publish("Unknown command " + s + "\n");
        }
    }
}

