/*
 * Decompiled with CFR 0.152.
 */
package maslab.telemetry.botclient;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import maslab.telemetry.StatusEvent;
import maslab.telemetry.StatusListener;
import maslab.telemetry.botclient.BotClient;
import maslab.telemetry.botclient.PluginController;
import maslab.util.Logger;

public class ControlPanel
extends JInternalFrame
implements ActionListener,
StatusListener {
    BotClient bc;
    YellowTextField ipTextField;
    JTextField botCommandField;
    JList list;
    JLabel status;
    JLabel botCommandLabel;
    DefaultListModel listModel;
    PopupListener pl;
    static final long serialVersionUID = 1001L;
    static Logger log = new Logger("ControlPanel");

    public ControlPanel(BotClient bc) {
        this.setSize(220, 250);
        this.setTitle("Control Panel");
        this.setBackground(Color.lightGray);
        this.setIconifiable(true);
        this.setResizable(true);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.getContentPane().setLayout(gb);
        JLabel label = new JLabel("Available Channels");
        c.gridwidth = 2;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 30.0;
        c.weighty = 0.0;
        c.fill = 0;
        gb.setConstraints(label, c);
        this.getContentPane().add(label);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        JScrollPane scrollPane = new JScrollPane(this.list);
        c.gridwidth = 2;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 70.0;
        c.weighty = 70.0;
        c.fill = 1;
        gb.setConstraints(scrollPane, c);
        this.getContentPane().add(scrollPane);
        label = new JLabel("Robot IP: ");
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 0;
        gb.setConstraints(label, c);
        this.getContentPane().add(label);
        this.ipTextField = new YellowTextField("127.0.0.1");
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 1;
        c.gridy = 3;
        c.weightx = 30.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        gb.setConstraints(this.ipTextField, c);
        this.getContentPane().add(this.ipTextField);
        this.botCommandLabel = new JLabel("Send Command: ");
        this.botCommandLabel.setEnabled(false);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 4;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 0;
        gb.setConstraints(this.botCommandLabel, c);
        this.getContentPane().add(this.botCommandLabel);
        this.botCommandField = new JTextField();
        this.botCommandField.setEnabled(false);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 1;
        c.gridy = 4;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        gb.setConstraints(this.botCommandField, c);
        this.getContentPane().add(this.botCommandField);
        label = new JLabel("Status: ");
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 5;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 0;
        gb.setConstraints(label, c);
        this.getContentPane().add(label);
        this.status = new JLabel("Disconnected");
        this.status.setForeground(Color.red);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 1;
        c.gridy = 5;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 0;
        gb.setConstraints(this.status, c);
        this.getContentPane().add(this.status);
        this.ipTextField.addActionListener(this);
        this.botCommandField.addActionListener(this);
        this.pl = new PopupListener();
        this.list.addMouseListener(this.pl);
        this.setVisible(true);
        this.bc = bc;
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.ipTextField) {
            this.ipTextField.setBackground(Color.white);
            this.list.grabFocus();
            try {
                InetAddress ip = InetAddress.getByName(e.getActionCommand());
                this.bc.setIP(ip);
            }
            catch (UnknownHostException uhe) {
                JOptionPane.showMessageDialog(null, "Unknown host: " + e.getActionCommand());
            }
            return;
        }
        if (o == this.botCommandField) {
            this.bc.userCommand(e.getActionCommand());
            this.botCommandField.setText("");
        }
    }

    public void statusChanged(StatusEvent e) {
        log.vverbose("Status Changed: " + e.name + " = " + e.booleanValue);
        String name = e.name;
        if (name.equals("connected")) {
            if (e.booleanValue) {
                this.status.setText("Connected");
                this.status.setForeground(Color.green);
                this.botCommandLabel.setEnabled(true);
                this.botCommandField.setEnabled(true);
                this.refreshChannelList();
            } else {
                this.status.setText("Disconnected");
                this.status.setForeground(Color.red);
                this.botCommandLabel.setEnabled(false);
                this.botCommandField.setEnabled(false);
                this.listModel = new DefaultListModel();
                this.list.setModel(this.listModel);
            }
        }
        if (name.equals("newchannel")) {
            this.refreshChannelList();
        }
    }

    void refreshChannelList() {
        this.listModel = new DefaultListModel();
        this.list.setModel(this.listModel);
        ArrayList channels = this.bc.getChannels();
        for (int i = 0; i < channels.size(); ++i) {
            String[] nametype = ((String)channels.get(i)).split("\\$");
            if (nametype[1].equals("hidden")) continue;
            this.listModel.addElement(new ChannelListItem(nametype[0], nametype[1]));
        }
        this.list.repaint();
    }

    class ChannelListItem {
        public String name;
        public String type;
        public JPopupMenu pop;

        public ChannelListItem(String name, String type) {
            this.name = name;
            this.type = type;
            this.pop = new JPopupMenu();
            String[] plugins = ControlPanel.this.bc.getPlugins(type);
            if (plugins != null) {
                for (int i = 0; i < plugins.length; ++i) {
                    JMenuItem item = new JMenuItem(PluginController.shortName(plugins[i]));
                    this.pop.add(item);
                    item.addActionListener(ControlPanel.this.pl);
                }
            }
        }

        public String toString() {
            return this.name + " - " + this.type;
        }
    }

    class PopupListener
    extends MouseAdapter
    implements ActionListener {
        ChannelListItem item;
        String def;

        PopupListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 2 || !SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            int index = ControlPanel.this.list.locationToIndex(e.getPoint());
            if (index == -1) {
                return;
            }
            this.item = (ChannelListItem)ControlPanel.this.listModel.getElementAt(index);
            log.verbose("Instantiating default handler for type " + this.item.type);
            ControlPanel.this.bc.newDefaultHandler(this.item.name, this.item.type);
        }

        public void mouseReleased(MouseEvent e) {
            int index;
            if (SwingUtilities.isRightMouseButton(e) && (index = ControlPanel.this.list.locationToIndex(e.getPoint())) != -1) {
                this.item = (ChannelListItem)ControlPanel.this.listModel.getElementAt(index);
                this.item.pop.show(ControlPanel.this.list, e.getX(), e.getY());
                ControlPanel.this.list.setSelectedIndex(index);
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (this.item == null) {
                return;
            }
            String pluginName = e.getActionCommand();
            ControlPanel.this.bc.newHandler(this.item.name, this.item.type, pluginName);
        }
    }

    class YellowTextField
    extends JTextField
    implements DocumentListener {
        static final long serialVersionUID = 1001L;

        public YellowTextField(String s) {
            super(s);
            this.getDocument().addDocumentListener(this);
        }

        public void changedUpdate(DocumentEvent e) {
            this.setBackground(Color.yellow);
        }

        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }
    }
}

