/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.examples;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import org.orcboard.camera.Camera;
import org.orcboard.camera.ImageUtil;
import org.orcboard.orc.Orc;
import org.orcboard.util.GetOpt;
import org.orcboard.util.JImage;

public class OrcCamera {
    public static void main(String[] args) {
        boolean useOrc = true;
        boolean showImage = true;
        GetOpt opt = new GetOpt();
        opt.addBoolean('h', "help", false, "Show this help");
        opt.addInt('\u0000', "fps", 5, "frame rate");
        opt.addBoolean('\u0000', "orc", true, "Send images to OrcPad");
        opt.addBoolean('\u0000', "display", true, "Show images in a window");
        if (!opt.parse(args) || opt.getBoolean("help")) {
            opt.doHelp();
            return;
        }
        useOrc = opt.getBoolean("orc");
        showImage = opt.getBoolean("display");
        Orc orc = null;
        if (useOrc) {
            orc = Orc.makeOrc();
            orc.lcdClear();
        }
        Camera cam = Camera.makeCamera();
        cam.setCaptureSettings(160, 120, opt.getInt("fps"));
        JFrame frame = null;
        JImage jim = null;
        if (showImage) {
            frame = new JFrame("OrcCamera");
            jim = new JImage();
            jim.setScale(true);
            frame.setLayout(new BorderLayout());
            frame.add((Component)jim, "Center");
            frame.setSize(640, 480);
            frame.setVisible(true);
        }
        int frames = 0;
        long startTime = System.currentTimeMillis();
        while (true) {
            BufferedImage im = cam.capture();
            im = ImageUtil.scaleImage(im, 128, 56);
            im = ImageUtil.ditherImageFloydSteinberg(im);
            if (showImage) {
                jim.setImage(im);
            }
            if (useOrc) {
                orc.lcdDrawImage(0, 8, im);
            }
            if (++frames != 40) continue;
            long nowTime = System.currentTimeMillis();
            double elapsedTime = (float)(nowTime - startTime) / 1000.0f;
            double fps = (double)frames / elapsedTime;
            System.out.println(String.format("FPS: %5.2f", fps));
            frames = 0;
            startTime = nowTime;
        }
    }
}

