/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orc;

import org.orcboard.orc.Orc;
import org.orcboard.orcspy.WaveformSettings;
import org.orcboard.orcspy.WaveformSource;

public class AnalogInput
implements WaveformSource {
    Orc orc;
    public int port;
    public static final int MOTOR_CURRENT_OFFSET = 16;
    public static final int PORT_CURRENT_OFFSET = 20;
    public static final int BATTERY_VOLTAGE_PORT = 23;

    public AnalogInput(Orc orc, int port) {
        this.orc = orc;
        assert (port >= 0 && port <= 23);
        this.port = port;
    }

    public double read() {
        int v = this.orc.doTransactionRetry16(new byte[]{4, (byte)this.port});
        return 5.0 * (double)v / 65535.0;
    }

    public void setFilter(int a) {
        assert (a >= 0 && a <= 65535);
        this.orc.doTransactionRetryVoid(new byte[]{16, (byte)this.port, (byte)(a >> 8 & 0xFF), (byte)(a & 0xFF)});
    }

    public double getWaveformSample() {
        return this.read();
    }

    public WaveformSettings getDefaultWaveformSettings() {
        return new WaveformSettings("Analog In " + this.port, "V", 0.0, 5.0, 0.5);
    }
}

