/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orc;

import org.orcboard.orc.Orc;

public class Benchmark {
    Orc orc;
    boolean usepad;
    int reqlen;
    int resplen;
    int nthreads;
    long xsum = 0L;
    long xcount = 0L;
    long xmin = 99999L;
    long xmax = 0L;
    boolean stop = false;
    long inbytes = 0L;
    long outbytes = 0L;

    public static void main(String[] args) {
        Orc orc = Orc.makeOrc();
        System.out.println(String.format("%5s %8s %8s %5s %10s %10s %10s %10s %10s %10s %10s", "dest", "reqsz", "rpysz", "nthr", "outbw", "inbw", "totbw", "tps", "minlat", "avglat", "maxlat"));
        Benchmark.dorun(orc, false, 0, 0);
        Benchmark.dorun(orc, false, 32, 0);
        Benchmark.dorun(orc, false, 0, 32);
        Benchmark.dorun(orc, false, 32, 32);
        Benchmark.dorun(orc, true, 0, 0);
        Benchmark.dorun(orc, true, 32, 0);
        Benchmark.dorun(orc, true, 0, 32);
        Benchmark.dorun(orc, true, 32, 32);
    }

    public static void dorun(Orc orc, boolean usepad, int reqsize, int respsize) {
        int mthreads = 32;
        for (int i = 1; i <= mthreads; i *= 2) {
            new Benchmark(orc, usepad, reqsize, respsize, i).run();
        }
    }

    public Benchmark(Orc orc, boolean usepad, int reqlen, int resplen, int nthreads) {
        this.orc = orc;
        this.usepad = usepad;
        this.reqlen = reqlen;
        this.resplen = resplen;
        this.nthreads = nthreads;
    }

    public void run() {
        RunThread[] threads = new RunThread[this.nthreads];
        for (int i = 0; i < this.nthreads; ++i) {
            threads[i] = new RunThread();
            threads[i].start();
        }
        double elapsedTime = 10.0;
        Orc.safesleep(2000);
        this.reset();
        Orc.safesleep((int)(elapsedTime * 1000.0));
        this.stop = true;
        for (int i = 0; i < this.nthreads; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        double xavg = (double)this.xsum / (double)this.xcount;
        double tps = (double)this.xcount / elapsedTime;
        double outbw = (double)this.outbytes / 1024.0 / elapsedTime;
        double inbw = (double)this.inbytes / 1024.0 / elapsedTime;
        System.out.println(String.format("%5s %8d %8d %5d %10.3f %10.3f %10.3f %10.2f %10.3f %10.3f %10.3f", this.usepad ? "pad" : "orc", this.reqlen, this.resplen, this.nthreads, outbw, inbw, outbw + inbw, tps, (double)this.xmin / 1000000.0, xavg / 1000000.0, (double)this.xmax / 1000000.0));
    }

    synchronized void reset() {
        this.xsum = 0L;
        this.xcount = 0L;
        this.xmax = 0L;
        this.xmin = 999999999L;
        this.outbytes = 0L;
        this.inbytes = 0L;
    }

    synchronized void transactionDone(long nanos) {
        this.xsum += nanos;
        ++this.xcount;
        if (nanos < this.xmin) {
            this.xmin = nanos;
        }
        if (nanos > this.xmax) {
            this.xmax = nanos;
        }
        this.outbytes += (long)(6 + this.reqlen);
        this.inbytes += (long)(5 + this.resplen);
    }

    class RunThread
    extends Thread {
        RunThread() {
        }

        public void run() {
            while (!Benchmark.this.stop) {
                long xstart = System.nanoTime();
                if (Benchmark.this.usepad) {
                    Benchmark.this.orc.doPadNull(Benchmark.this.reqlen, Benchmark.this.resplen);
                } else {
                    Benchmark.this.orc.doOrcNull(Benchmark.this.reqlen, Benchmark.this.resplen);
                }
                long xend = System.nanoTime();
                Benchmark.this.transactionDone(xend - xstart);
            }
        }
    }
}

