/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orc;

import org.orcboard.orc.Orc;
import org.orcboard.orcspy.WaveformSettings;
import org.orcboard.orcspy.WaveformSource;

public class Gyro
implements WaveformSource {
    Orc orc;
    public int port;
    double offset = 0.0;
    double scalefactor;
    static boolean inuse = false;
    double offset2 = 0.0;

    public Gyro(Orc orc, int port) {
        this(orc, port, 1.0);
    }

    public Gyro(Orc orc, int port, double scalefactor) {
        this.orc = orc;
        this.port = port;
        this.scalefactor = scalefactor;
        if (inuse) {
            System.out.println("WARNING! Only one gyro supported at a time");
        }
        inuse = true;
        orc.doTransactionRetryVoid(new byte[]{5, (byte)port});
    }

    public void beginCalibration(double seconds) {
        int mseconds = (int)(seconds * 1000.0);
        this.orc.doTransactionRetryVoid(new byte[]{6, (byte)(mseconds >> 8 & 0xFF), (byte)(mseconds & 0xFF)});
    }

    public void calibrate(double seconds) {
        int mseconds = (int)(seconds * 1000.0);
        this.beginCalibration(seconds);
        try {
            Thread.sleep(mseconds);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    public void reset() {
        this.offset = this.readReal();
    }

    double readReal() {
        int v = this.orc.doTransactionRetry32(new byte[]{7});
        return (double)v / 100.0;
    }

    public double getCalibrationVoltage() {
        byte[] resp = this.orc.doTransactionRetry(new byte[]{19});
        int calib = Orc.get16u(resp, 1);
        int calib_sum = Orc.get32s(resp, 3);
        int calib_num = Orc.get32u(resp, 7);
        double c = (double)calib_sum / (double)calib_num;
        c = c * 5.0 / 65535.0;
        if (calib != 0) {
            System.err.println("getCalibrationVoltage() called while calibration in progress");
        }
        return c + 2.5;
    }

    public double read() {
        double v = this.readReal();
        return (v - this.offset) * this.scalefactor;
    }

    public double getWaveformSample() {
        return this.read();
    }

    public WaveformSettings getDefaultWaveformSettings() {
        return new WaveformSettings("Gyro", "Degrees", -Math.PI, Math.PI, 0.0);
    }

    public static void main(String[] args) {
        Orc orc = Orc.makeOrc();
        if (args.length != 1) {
            System.out.println("Provide a port # as argument");
            return;
        }
        int port = Integer.parseInt(args[0]);
        Gyro g = new Gyro(orc, port);
        int iter = 0;
        while (true) {
            double calibtime = 0.0;
            switch (iter) {
                case 0: {
                    calibtime = 5.0;
                    break;
                }
                case 1: {
                    calibtime = 10.0;
                    break;
                }
                case 2: {
                    calibtime = 20.0;
                }
            }
            if (++iter == 3) {
                iter = 0;
            }
            g.calibrate(calibtime);
            g.reset();
            Orc.safesleep(100);
            double cv = g.getCalibrationVoltage();
            System.out.print(String.format("%4.1f %8.5f ", calibtime, cv));
            for (int i = 0; i < 120; ++i) {
                Orc.safesleep(1000);
                System.out.print(String.format("%8.3f ", g.read()));
            }
            System.out.println("");
        }
    }
}

