/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orc;

import java.io.DataInputStream;
import org.orcboard.orc.AnalogInput;
import org.orcboard.orc.Orc;

public class Servo {
    Orc orc;
    int port;
    int pwm1;
    int pwm2;
    double theta1;
    double theta2;
    AnalogInput ain;

    protected Servo(Orc orc, int port) {
        this(orc, port, 0, 0.0, 65535, 180.0);
    }

    public Servo(Orc orc, int port, int pwm1, double theta1, int pwm2, double theta2) {
        this.orc = orc;
        this.port = port;
        this.calibrate(pwm1, theta1, pwm2, theta2);
        orc.setPinMode(port, Orc.PinMode.PWM);
        if (port <= 2) {
            this.ain = new AnalogInput(orc, 20 + port);
        }
    }

    public static Servo makeHitecHS300(Orc orc, int port) {
        return new Servo(orc, port, 2500, 0.0, 12000, Math.PI);
    }

    public void idle() {
        this.setPWMReal(0);
    }

    public void setPWM(int val) {
        val = Servo.min(Servo.max(this.pwm1, this.pwm2), val);
        val = Servo.max(Servo.min(this.pwm1, this.pwm2), val);
        this.setPWMReal(val);
    }

    void setPWMReal(int val) {
        this.orc.doTransactionRetryVoid(new byte[]{12, (byte)this.port, (byte)(val >> 8), (byte)(val & 0xFF)});
    }

    public void calibrate(int pwm1, double theta1, int pwm2, double theta2) {
        this.pwm1 = pwm1;
        this.pwm2 = pwm2;
        this.theta1 = theta1;
        this.theta2 = theta2;
    }

    protected static final int min(int a, int b) {
        return a < b ? a : b;
    }

    protected static final int max(int a, int b) {
        return a > b ? a : b;
    }

    public void set(double theta) {
        int pwm = (int)((double)(this.pwm2 - this.pwm1) * (theta - this.theta1) / (this.theta2 - this.theta1) + (double)this.pwm1);
        this.setPWM(pwm);
    }

    public double getCurrent() {
        if (this.port <= 2) {
            return this.ain.read() / 0.18;
        }
        return 0.0;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: <servo port>");
            return;
        }
        int port = Integer.parseInt(args[0]);
        Orc orc = Orc.makeOrc();
        Servo s = new Servo(orc, port);
        DataInputStream ins = new DataInputStream(System.in);
        System.out.println("Commands:\n");
        System.out.println("  pwm    <pwmval>");
        System.out.println("     Set the actual PWM value\n");
        System.out.println("  config <pwm1> <theta1> <pwm2> <theta2>");
        System.out.println("     Configure the servo with the given parameters.\n");
        System.out.println("  theta  <theta>");
        System.out.println("     Using the current servo paramteters, seek theta.\n");
        while (true) {
            System.out.print("servo> ");
            try {
                String line = ins.readLine();
                String[] toks = line.split("\\s+");
                if (toks.length < 2) continue;
                if (toks[0].equals("pwm")) {
                    int pwm = Integer.parseInt(toks[1]);
                    s.setPWM(pwm);
                }
                if (toks[0].equals("config")) {
                    int pwm1 = Integer.parseInt(toks[1]);
                    double theta1 = Double.parseDouble(toks[2]);
                    int pwm2 = Integer.parseInt(toks[3]);
                    double theta2 = Double.parseDouble(toks[4]);
                    s.calibrate(pwm1, theta1, pwm2, theta2);
                }
                if (!toks[0].equals("theta")) continue;
                double theta = Double.parseDouble(toks[1]);
                s.set(theta);
                continue;
            }
            catch (Exception ex) {
                System.out.println("Malformed pwm. [0-65535], please.");
                continue;
            }
            break;
        }
    }
}

