/*
 * Decompiled with CFR 0.152.
 */
package org.orcboard.orc;

import org.orcboard.orc.AnalogInput;
import org.orcboard.orc.Orc;

public class Motor {
    Orc orc;
    public int port;
    boolean reverse = false;
    AnalogInput ain;

    public Motor(Orc orc, int port) {
        this(orc, port, false);
    }

    public Motor(Orc orc, int port, boolean reverse) {
        this.orc = orc;
        assert (port >= 0 && port <= 3);
        this.port = port;
        this.reverse = reverse;
        this.ain = new AnalogInput(orc, 16 + port);
    }

    public void set(double v) {
        int dir;
        int mag = (int)Math.round(Math.abs(v) * 127.0);
        if (mag > 127) {
            mag = 127;
        }
        int n = dir = v < 0.0 ^ this.reverse ? 128 : 0;
        if (mag == 0) {
            dir = 0;
        }
        int cmd = dir | mag;
        this.orc.doTransactionRetryVoid(new byte[]{1, (byte)this.port, (byte)cmd});
    }

    public void idle() {
        this.orc.doTransactionRetryVoid(new byte[]{1, (byte)this.port, -128});
    }

    public double getCurrent() {
        double v = this.ain.read();
        return v / 0.18;
    }

    public void setAcceleration(int rate) {
        this.orc.doTransactionRetryVoid(new byte[]{1, (byte)this.port, (byte)(rate & 0xFF)});
    }
}

